/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.tekton.pipeline.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.tekton.pipeline.v1beta1.PipelineRef;
import io.fabric8.tekton.pipeline.v1beta1.PipelineRefFluent;
import io.fabric8.tekton.pipeline.v1beta1.ResolverParam;
import io.fabric8.tekton.pipeline.v1beta1.ResolverParamBuilder;
import io.fabric8.tekton.pipeline.v1beta1.ResolverParamFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class PipelineRefFluentImpl<A extends PipelineRefFluent<A>>
extends BaseFluent<A>
implements PipelineRefFluent<A> {
    private String apiVersion;
    private String bundle;
    private String name;
    private String resolver;
    private ArrayList<ResolverParamBuilder> resource = new ArrayList();

    public PipelineRefFluentImpl() {
    }

    public PipelineRefFluentImpl(PipelineRef instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withBundle(instance.getBundle());
        this.withName(instance.getName());
        this.withResolver(instance.getResolver());
        this.withResource(instance.getResource());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public String getBundle() {
        return this.bundle;
    }

    @Override
    public A withBundle(String bundle) {
        this.bundle = bundle;
        return (A)this;
    }

    @Override
    public Boolean hasBundle() {
        return this.bundle != null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    public String getResolver() {
        return this.resolver;
    }

    @Override
    public A withResolver(String resolver) {
        this.resolver = resolver;
        return (A)this;
    }

    @Override
    public Boolean hasResolver() {
        return this.resolver != null;
    }

    @Override
    public A addToResource(Integer index, ResolverParam item) {
        if (this.resource == null) {
            this.resource = new ArrayList();
        }
        ResolverParamBuilder builder = new ResolverParamBuilder(item);
        this._visitables.get((Object)"resource").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"resource").size(), builder);
        this.resource.add(index >= 0 ? index.intValue() : this.resource.size(), builder);
        return (A)this;
    }

    @Override
    public A setToResource(Integer index, ResolverParam item) {
        if (this.resource == null) {
            this.resource = new ArrayList();
        }
        ResolverParamBuilder builder = new ResolverParamBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"resource").size()) {
            this._visitables.get((Object)"resource").add(builder);
        } else {
            this._visitables.get((Object)"resource").set(index, builder);
        }
        if (index < 0 || index >= this.resource.size()) {
            this.resource.add(builder);
        } else {
            this.resource.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToResource(ResolverParam ... items) {
        if (this.resource == null) {
            this.resource = new ArrayList();
        }
        for (ResolverParam item : items) {
            ResolverParamBuilder builder = new ResolverParamBuilder(item);
            this._visitables.get((Object)"resource").add(builder);
            this.resource.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToResource(Collection<ResolverParam> items) {
        if (this.resource == null) {
            this.resource = new ArrayList();
        }
        for (ResolverParam item : items) {
            ResolverParamBuilder builder = new ResolverParamBuilder(item);
            this._visitables.get((Object)"resource").add(builder);
            this.resource.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromResource(ResolverParam ... items) {
        for (ResolverParam item : items) {
            ResolverParamBuilder builder = new ResolverParamBuilder(item);
            this._visitables.get((Object)"resource").remove(builder);
            if (this.resource == null) continue;
            this.resource.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromResource(Collection<ResolverParam> items) {
        for (ResolverParam item : items) {
            ResolverParamBuilder builder = new ResolverParamBuilder(item);
            this._visitables.get((Object)"resource").remove(builder);
            if (this.resource == null) continue;
            this.resource.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromResource(Predicate<ResolverParamBuilder> predicate) {
        if (this.resource == null) {
            return (A)this;
        }
        Iterator<ResolverParamBuilder> each = this.resource.iterator();
        List visitables = this._visitables.get((Object)"resource");
        while (each.hasNext()) {
            ResolverParamBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ResolverParam> getResource() {
        return this.resource != null ? PipelineRefFluentImpl.build(this.resource) : null;
    }

    @Override
    public List<ResolverParam> buildResource() {
        return this.resource != null ? PipelineRefFluentImpl.build(this.resource) : null;
    }

    @Override
    public ResolverParam buildResource(Integer index) {
        return this.resource.get(index).build();
    }

    @Override
    public ResolverParam buildFirstResource() {
        return this.resource.get(0).build();
    }

    @Override
    public ResolverParam buildLastResource() {
        return this.resource.get(this.resource.size() - 1).build();
    }

    @Override
    public ResolverParam buildMatchingResource(Predicate<ResolverParamBuilder> predicate) {
        for (ResolverParamBuilder item : this.resource) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingResource(Predicate<ResolverParamBuilder> predicate) {
        for (ResolverParamBuilder item : this.resource) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withResource(List<ResolverParam> resource) {
        if (this.resource != null) {
            this._visitables.get((Object)"resource").removeAll(this.resource);
        }
        if (resource != null) {
            this.resource = new ArrayList();
            for (ResolverParam item : resource) {
                this.addToResource(item);
            }
        } else {
            this.resource = null;
        }
        return (A)this;
    }

    @Override
    public A withResource(ResolverParam ... resource) {
        if (this.resource != null) {
            this.resource.clear();
        }
        if (resource != null) {
            for (ResolverParam item : resource) {
                this.addToResource(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasResource() {
        return this.resource != null && !this.resource.isEmpty();
    }

    @Override
    public A addNewResource(String name, String value) {
        return this.addToResource(new ResolverParam(name, value));
    }

    @Override
    public PipelineRefFluent.ResourceNested<A> addNewResource() {
        return new ResourceNestedImpl();
    }

    @Override
    public PipelineRefFluent.ResourceNested<A> addNewResourceLike(ResolverParam item) {
        return new ResourceNestedImpl(-1, item);
    }

    @Override
    public PipelineRefFluent.ResourceNested<A> setNewResourceLike(Integer index, ResolverParam item) {
        return new ResourceNestedImpl(index, item);
    }

    @Override
    public PipelineRefFluent.ResourceNested<A> editResource(Integer index) {
        if (this.resource.size() <= index) {
            throw new RuntimeException("Can't edit resource. Index exceeds size.");
        }
        return this.setNewResourceLike(index, this.buildResource(index));
    }

    @Override
    public PipelineRefFluent.ResourceNested<A> editFirstResource() {
        if (this.resource.size() == 0) {
            throw new RuntimeException("Can't edit first resource. The list is empty.");
        }
        return this.setNewResourceLike(0, this.buildResource(0));
    }

    @Override
    public PipelineRefFluent.ResourceNested<A> editLastResource() {
        int index = this.resource.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last resource. The list is empty.");
        }
        return this.setNewResourceLike(index, this.buildResource(index));
    }

    @Override
    public PipelineRefFluent.ResourceNested<A> editMatchingResource(Predicate<ResolverParamBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.resource.size(); ++i) {
            if (!predicate.test(this.resource.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching resource. No match found.");
        }
        return this.setNewResourceLike(index, this.buildResource(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PipelineRefFluentImpl that = (PipelineRefFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.bundle != null ? !this.bundle.equals(that.bundle) : that.bundle != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.resolver != null ? !this.resolver.equals(that.resolver) : that.resolver != null) {
            return false;
        }
        return !(this.resource != null ? !this.resource.equals(that.resource) : that.resource != null);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.bundle, this.name, this.resolver, this.resource, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.bundle != null) {
            sb.append("bundle:");
            sb.append(this.bundle + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.resolver != null) {
            sb.append("resolver:");
            sb.append(this.resolver + ",");
        }
        if (this.resource != null && !this.resource.isEmpty()) {
            sb.append("resource:");
            sb.append(this.resource);
        }
        sb.append("}");
        return sb.toString();
    }

    class ResourceNestedImpl<N>
    extends ResolverParamFluentImpl<PipelineRefFluent.ResourceNested<N>>
    implements PipelineRefFluent.ResourceNested<N>,
    Nested<N> {
        ResolverParamBuilder builder;
        Integer index;

        ResourceNestedImpl(Integer index, ResolverParam item) {
            this.index = index;
            this.builder = new ResolverParamBuilder(this, item);
        }

        ResourceNestedImpl() {
            this.index = -1;
            this.builder = new ResolverParamBuilder(this);
        }

        @Override
        public N and() {
            return (N)PipelineRefFluentImpl.this.setToResource(this.index, this.builder.build());
        }

        @Override
        public N endResource() {
            return this.and();
        }
    }
}

