package io.fabric8.tekton.triggers.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TriggerListBuilder extends TriggerListFluentImpl<TriggerListBuilder> implements VisitableBuilder<TriggerList,TriggerListBuilder>{
  public TriggerListBuilder() {
    this(false);
  }
  public TriggerListBuilder(Boolean validationEnabled) {
    this(new TriggerList(), validationEnabled);
  }
  public TriggerListBuilder(TriggerListFluent<?> fluent) {
    this(fluent, false);
  }
  public TriggerListBuilder(TriggerListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TriggerList(), validationEnabled);
  }
  public TriggerListBuilder(TriggerListFluent<?> fluent,TriggerList instance) {
    this(fluent, instance, false);
  }
  public TriggerListBuilder(TriggerListFluent<?> fluent,TriggerList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  public TriggerListBuilder(TriggerList instance) {
    this(instance,false);
  }
  public TriggerListBuilder(TriggerList instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  TriggerListFluent<?> fluent;
  Boolean validationEnabled;
  public TriggerList build() {
    TriggerList buildable = new TriggerList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}