package io.fabric8.tekton.triggers.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class EventListenerListBuilder extends EventListenerListFluentImpl<EventListenerListBuilder> implements VisitableBuilder<EventListenerList,EventListenerListBuilder>{
  public EventListenerListBuilder() {
    this(false);
  }
  public EventListenerListBuilder(Boolean validationEnabled) {
    this(new EventListenerList(), validationEnabled);
  }
  public EventListenerListBuilder(EventListenerListFluent<?> fluent) {
    this(fluent, false);
  }
  public EventListenerListBuilder(EventListenerListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new EventListenerList(), validationEnabled);
  }
  public EventListenerListBuilder(EventListenerListFluent<?> fluent,EventListenerList instance) {
    this(fluent, instance, false);
  }
  public EventListenerListBuilder(EventListenerListFluent<?> fluent,EventListenerList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  public EventListenerListBuilder(EventListenerList instance) {
    this(instance,false);
  }
  public EventListenerListBuilder(EventListenerList instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  EventListenerListFluent<?> fluent;
  Boolean validationEnabled;
  public EventListenerList build() {
    EventListenerList buildable = new EventListenerList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}