package io.fabric8.tekton.triggers.v1alpha1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ClientConfigFluentImpl<A extends ClientConfigFluent<A>> extends BaseFluent<A> implements ClientConfigFluent<A>{
  public ClientConfigFluentImpl() {
  }
  public ClientConfigFluentImpl(ClientConfig instance) {
    this.withCaBundle(instance.getCaBundle()); 
    this.withService(instance.getService()); 
    this.withUrl(instance.getUrl()); 
  }
  private String caBundle;
  private ServiceReferenceBuilder service;
  private String url;
  public String getCaBundle() {
    return this.caBundle;
  }
  public A withCaBundle(String caBundle) {
    this.caBundle=caBundle; return (A) this;
  }
  public Boolean hasCaBundle() {
    return this.caBundle != null;
  }
  
  /**
   * This method has been deprecated, please use method buildService instead.
   * @return The buildable object.
   */
  @Deprecated
  public ServiceReference getService() {
    return this.service!=null ?this.service.build():null;
  }
  public ServiceReference buildService() {
    return this.service!=null ?this.service.build():null;
  }
  public A withService(ServiceReference service) {
    _visitables.get("service").remove(this.service);
    if (service!=null){ this.service= new ServiceReferenceBuilder(service); _visitables.get("service").add(this.service);} else { this.service = null; _visitables.get("service").remove(this.service); } return (A) this;
  }
  public Boolean hasService() {
    return this.service != null;
  }
  public A withNewService(String name,String namespace,String path,Integer port) {
    return (A)withService(new ServiceReference(name, namespace, path, port));
  }
  public ClientConfigFluent.ServiceNested<A> withNewService() {
    return new ClientConfigFluentImpl.ServiceNestedImpl();
  }
  public ClientConfigFluent.ServiceNested<A> withNewServiceLike(ServiceReference item) {
    return new ClientConfigFluentImpl.ServiceNestedImpl(item);
  }
  public ClientConfigFluent.ServiceNested<A> editService() {
    return withNewServiceLike(getService());
  }
  public ClientConfigFluent.ServiceNested<A> editOrNewService() {
    return withNewServiceLike(getService() != null ? getService(): new ServiceReferenceBuilder().build());
  }
  public ClientConfigFluent.ServiceNested<A> editOrNewServiceLike(ServiceReference item) {
    return withNewServiceLike(getService() != null ? getService(): item);
  }
  public String getUrl() {
    return this.url;
  }
  public A withUrl(String url) {
    this.url=url; return (A) this;
  }
  public Boolean hasUrl() {
    return this.url != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ClientConfigFluentImpl that = (ClientConfigFluentImpl) o;
    if (caBundle != null ? !caBundle.equals(that.caBundle) :that.caBundle != null) return false;
    if (service != null ? !service.equals(that.service) :that.service != null) return false;
    if (url != null ? !url.equals(that.url) :that.url != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(caBundle,  service,  url,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (caBundle != null) { sb.append("caBundle:"); sb.append(caBundle + ","); }
    if (service != null) { sb.append("service:"); sb.append(service + ","); }
    if (url != null) { sb.append("url:"); sb.append(url); }
    sb.append("}");
    return sb.toString();
  }
  class ServiceNestedImpl<N> extends ServiceReferenceFluentImpl<ClientConfigFluent.ServiceNested<N>> implements ClientConfigFluent.ServiceNested<N>,Nested<N>{
    ServiceNestedImpl(ServiceReference item) {
      this.builder = new ServiceReferenceBuilder(this, item);
    }
    ServiceNestedImpl() {
      this.builder = new ServiceReferenceBuilder(this);
    }
    ServiceReferenceBuilder builder;
    public N and() {
      return (N) ClientConfigFluentImpl.this.withService(builder.build());
    }
    public N endService() {
      return and();
    }
    
  }
  
}