package io.fabric8.tekton.triggers.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluent;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import io.fabric8.kubernetes.api.model.GenericKubernetesResourceBuilder;
import io.fabric8.kubernetes.api.model.GenericKubernetesResourceFluent;
import java.util.Collection;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import java.lang.Object;
import java.util.Map;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.GenericKubernetesResource;
import java.util.Iterator;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class TriggerTemplateSpecFluent<A extends TriggerTemplateSpecFluent<A>> extends BaseFluent<A>{
  public TriggerTemplateSpecFluent() {
  }
  
  public TriggerTemplateSpecFluent(TriggerTemplateSpec instance) {
    this.copyInstance(instance);
  }
  private ArrayList<ParamSpecBuilder> params = new ArrayList<ParamSpecBuilder>();
  private ArrayList<VisitableBuilder<? extends HasMetadata,?>> resourcetemplates = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(TriggerTemplateSpec instance) {
    instance = (instance != null ? instance : new TriggerTemplateSpec());
    if (instance != null) {
          this.withParams(instance.getParams());
          this.withResourcetemplates(instance.getResourcetemplates());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToParams(int index,ParamSpec item) {
    if (this.params == null) {this.params = new ArrayList<ParamSpecBuilder>();}
    ParamSpecBuilder builder = new ParamSpecBuilder(item);
    if (index < 0 || index >= params.size()) { _visitables.get("params").add(builder); params.add(builder); } else { _visitables.get("params").add(index, builder); params.add(index, builder);}
    return (A)this;
  }
  
  public A setToParams(int index,ParamSpec item) {
    if (this.params == null) {this.params = new ArrayList<ParamSpecBuilder>();}
    ParamSpecBuilder builder = new ParamSpecBuilder(item);
    if (index < 0 || index >= params.size()) { _visitables.get("params").add(builder); params.add(builder); } else { _visitables.get("params").set(index, builder); params.set(index, builder);}
    return (A)this;
  }
  
  public A addToParams(io.fabric8.tekton.triggers.v1alpha1.ParamSpec... items) {
    if (this.params == null) {this.params = new ArrayList<ParamSpecBuilder>();}
    for (ParamSpec item : items) {ParamSpecBuilder builder = new ParamSpecBuilder(item);_visitables.get("params").add(builder);this.params.add(builder);} return (A)this;
  }
  
  public A addAllToParams(Collection<ParamSpec> items) {
    if (this.params == null) {this.params = new ArrayList<ParamSpecBuilder>();}
    for (ParamSpec item : items) {ParamSpecBuilder builder = new ParamSpecBuilder(item);_visitables.get("params").add(builder);this.params.add(builder);} return (A)this;
  }
  
  public A removeFromParams(io.fabric8.tekton.triggers.v1alpha1.ParamSpec... items) {
    if (this.params == null) return (A)this;
    for (ParamSpec item : items) {ParamSpecBuilder builder = new ParamSpecBuilder(item);_visitables.get("params").remove(builder); this.params.remove(builder);} return (A)this;
  }
  
  public A removeAllFromParams(Collection<ParamSpec> items) {
    if (this.params == null) return (A)this;
    for (ParamSpec item : items) {ParamSpecBuilder builder = new ParamSpecBuilder(item);_visitables.get("params").remove(builder); this.params.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromParams(Predicate<ParamSpecBuilder> predicate) {
    if (params == null) return (A) this;
    final Iterator<ParamSpecBuilder> each = params.iterator();
    final List visitables = _visitables.get("params");
    while (each.hasNext()) {
      ParamSpecBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<ParamSpec> buildParams() {
    return this.params != null ? build(params) : null;
  }
  
  public ParamSpec buildParam(int index) {
    return this.params.get(index).build();
  }
  
  public ParamSpec buildFirstParam() {
    return this.params.get(0).build();
  }
  
  public ParamSpec buildLastParam() {
    return this.params.get(params.size() - 1).build();
  }
  
  public ParamSpec buildMatchingParam(Predicate<ParamSpecBuilder> predicate) {
      for (ParamSpecBuilder item : params) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingParam(Predicate<ParamSpecBuilder> predicate) {
      for (ParamSpecBuilder item : params) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withParams(List<ParamSpec> params) {
    if (this.params != null) {
      this._visitables.get("params").clear();
    }
    if (params != null) {
        this.params = new ArrayList();
        for (ParamSpec item : params) {
          this.addToParams(item);
        }
    } else {
      this.params = null;
    }
    return (A) this;
  }
  
  public A withParams(io.fabric8.tekton.triggers.v1alpha1.ParamSpec... params) {
    if (this.params != null) {
        this.params.clear();
        _visitables.remove("params");
    }
    if (params != null) {
      for (ParamSpec item : params) {
        this.addToParams(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasParams() {
    return this.params != null && !this.params.isEmpty();
  }
  
  public A addNewParam(String _default,String description,String name) {
    return (A)addToParams(new ParamSpec(_default, description, name));
  }
  
  public ParamsNested<A> addNewParam() {
    return new ParamsNested(-1, null);
  }
  
  public ParamsNested<A> addNewParamLike(ParamSpec item) {
    return new ParamsNested(-1, item);
  }
  
  public ParamsNested<A> setNewParamLike(int index,ParamSpec item) {
    return new ParamsNested(index, item);
  }
  
  public ParamsNested<A> editParam(int index) {
    if (params.size() <= index) throw new RuntimeException("Can't edit params. Index exceeds size.");
    return setNewParamLike(index, buildParam(index));
  }
  
  public ParamsNested<A> editFirstParam() {
    if (params.size() == 0) throw new RuntimeException("Can't edit first params. The list is empty.");
    return setNewParamLike(0, buildParam(0));
  }
  
  public ParamsNested<A> editLastParam() {
    int index = params.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last params. The list is empty.");
    return setNewParamLike(index, buildParam(index));
  }
  
  public ParamsNested<A> editMatchingParam(Predicate<ParamSpecBuilder> predicate) {
    int index = -1;
    for (int i=0;i<params.size();i++) { 
    if (predicate.test(params.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching params. No match found.");
    return setNewParamLike(index, buildParam(index));
  }
  
  public A addToResourcetemplates(VisitableBuilder<? extends HasMetadata,?> builder) {
    if (this.resourcetemplates == null) {this.resourcetemplates = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    _visitables.get("resourcetemplates").add(builder);this.resourcetemplates.add(builder); return (A)this;
  }
  
  public A addToResourcetemplates(int index,VisitableBuilder<? extends HasMetadata,?> builder) {
    if (this.resourcetemplates == null) {this.resourcetemplates = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    if (index < 0 || index >= resourcetemplates.size()) { _visitables.get("resourcetemplates").add(builder); resourcetemplates.add(builder); } else { _visitables.get("resourcetemplates").add(index, builder); resourcetemplates.add(index, builder);}
    return (A)this;
  }
  
  public A addToResourcetemplates(int index,HasMetadata item) {
    if (this.resourcetemplates == null) {this.resourcetemplates = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    VisitableBuilder<? extends HasMetadata,?> builder = builder(item);
    if (index < 0 || index >= resourcetemplates.size()) { _visitables.get("resourcetemplates").add(builder); resourcetemplates.add(builder); } else { _visitables.get("resourcetemplates").add(index, builder); resourcetemplates.add(index, builder);}
    return (A)this;
  }
  
  public A setToResourcetemplates(int index,HasMetadata item) {
    if (this.resourcetemplates == null) {this.resourcetemplates = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    VisitableBuilder<? extends HasMetadata,?> builder = builder(item);
    if (index < 0 || index >= resourcetemplates.size()) { _visitables.get("resourcetemplates").add(builder); resourcetemplates.add(builder); } else { _visitables.get("resourcetemplates").set(index, builder); resourcetemplates.set(index, builder);}
    return (A)this;
  }
  
  public A addToResourcetemplates(io.fabric8.kubernetes.api.model.HasMetadata... items) {
    if (this.resourcetemplates == null) {this.resourcetemplates = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (HasMetadata item : items) { VisitableBuilder<? extends HasMetadata,?> builder = builder(item); _visitables.get("resourcetemplates").add(builder);this.resourcetemplates.add(builder); }
    return (A)this;
  }
  
  public A addAllToResourcetemplates(Collection<HasMetadata> items) {
    if (this.resourcetemplates == null) {this.resourcetemplates = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (HasMetadata item : items) { VisitableBuilder<? extends HasMetadata,?> builder = builder(item); _visitables.get("resourcetemplates").add(builder);this.resourcetemplates.add(builder); }
    return (A)this;
  }
  
  public A removeFromResourcetemplates(VisitableBuilder<? extends HasMetadata,?> builder) {
    if (this.resourcetemplates == null) return (A)this;
    _visitables.get("resourcetemplates").remove(builder);this.resourcetemplates.remove(builder); return (A)this;
  }
  
  public A removeFromResourcetemplates(io.fabric8.kubernetes.api.model.HasMetadata... items) {
    if (this.resourcetemplates == null) return (A)this;
    for (HasMetadata item : items) {
    VisitableBuilder<? extends HasMetadata,?> builder = builder(item); _visitables.get("resourcetemplates").remove(builder);this.resourcetemplates.remove(builder);
    } return (A)this;
  }
  
  public A removeAllFromResourcetemplates(Collection<HasMetadata> items) {
    if (this.resourcetemplates == null) return (A)this;
    for (HasMetadata item : items) {
    VisitableBuilder<? extends HasMetadata,?> builder = builder(item); _visitables.get("resourcetemplates").remove(builder);this.resourcetemplates.remove(builder);
    } return (A)this;
  }
  
  public A removeMatchingFromResourcetemplates(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
    if (resourcetemplates == null) return (A) this;
    final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = resourcetemplates.iterator();
    final List visitables = _visitables.get("resourcetemplates");
    while (each.hasNext()) {
      VisitableBuilder<? extends HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<HasMetadata> buildResourcetemplates() {
    return build(resourcetemplates);
  }
  
  public HasMetadata buildResourcetemplate(int index) {
    return this.resourcetemplates.get(index).build();
  }
  
  public HasMetadata buildFirstResourcetemplate() {
    return this.resourcetemplates.get(0).build();
  }
  
  public HasMetadata buildLastResourcetemplate() {
    return this.resourcetemplates.get(resourcetemplates.size() - 1).build();
  }
  
  public HasMetadata buildMatchingResourcetemplate(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
      for (VisitableBuilder<? extends HasMetadata,?> item : resourcetemplates) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingResourcetemplate(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
      for (VisitableBuilder<? extends HasMetadata,?> item : resourcetemplates) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withResourcetemplates(List<HasMetadata> resourcetemplates) {
    if (resourcetemplates != null) {
        this.resourcetemplates = new ArrayList();
        for (HasMetadata item : resourcetemplates) {
          this.addToResourcetemplates(item);
        }
    } else {
      this.resourcetemplates = null;
    }
    return (A) this;
  }
  
  public A withResourcetemplates(io.fabric8.kubernetes.api.model.HasMetadata... resourcetemplates) {
    if (this.resourcetemplates != null) {
        this.resourcetemplates.clear();
        _visitables.remove("resourcetemplates");
    }
    if (resourcetemplates != null) {
      for (HasMetadata item : resourcetemplates) {
        this.addToResourcetemplates(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasResourcetemplates() {
    return this.resourcetemplates != null && !this.resourcetemplates.isEmpty();
  }
  
  public TriggerTemplateResourcetemplatesNested<A> addNewTriggerTemplateResourcetemplate() {
    return new TriggerTemplateResourcetemplatesNested(-1, null);
  }
  
  public TriggerTemplateResourcetemplatesNested<A> addNewTriggerTemplateResourcetemplateLike(TriggerTemplate item) {
    return new TriggerTemplateResourcetemplatesNested(-1, item);
  }
  
  public TriggerTemplateResourcetemplatesNested<A> setNewTriggerTemplateResourcetemplateLike(int index,TriggerTemplate item) {
    return new TriggerTemplateResourcetemplatesNested(index, item);
  }
  
  public ClusterInterceptorResourcetemplatesNested<A> addNewClusterInterceptorResourcetemplate() {
    return new ClusterInterceptorResourcetemplatesNested(-1, null);
  }
  
  public ClusterInterceptorResourcetemplatesNested<A> addNewClusterInterceptorResourcetemplateLike(ClusterInterceptor item) {
    return new ClusterInterceptorResourcetemplatesNested(-1, item);
  }
  
  public ClusterInterceptorResourcetemplatesNested<A> setNewClusterInterceptorResourcetemplateLike(int index,ClusterInterceptor item) {
    return new ClusterInterceptorResourcetemplatesNested(index, item);
  }
  
  public TriggerBindingResourcetemplatesNested<A> addNewTriggerBindingResourcetemplate() {
    return new TriggerBindingResourcetemplatesNested(-1, null);
  }
  
  public TriggerBindingResourcetemplatesNested<A> addNewTriggerBindingResourcetemplateLike(TriggerBinding item) {
    return new TriggerBindingResourcetemplatesNested(-1, item);
  }
  
  public TriggerBindingResourcetemplatesNested<A> setNewTriggerBindingResourcetemplateLike(int index,TriggerBinding item) {
    return new TriggerBindingResourcetemplatesNested(index, item);
  }
  
  public ClusterTriggerBindingResourcetemplatesNested<A> addNewClusterTriggerBindingResourcetemplate() {
    return new ClusterTriggerBindingResourcetemplatesNested(-1, null);
  }
  
  public ClusterTriggerBindingResourcetemplatesNested<A> addNewClusterTriggerBindingResourcetemplateLike(ClusterTriggerBinding item) {
    return new ClusterTriggerBindingResourcetemplatesNested(-1, item);
  }
  
  public ClusterTriggerBindingResourcetemplatesNested<A> setNewClusterTriggerBindingResourcetemplateLike(int index,ClusterTriggerBinding item) {
    return new ClusterTriggerBindingResourcetemplatesNested(index, item);
  }
  
  public InterceptorResourcetemplatesNested<A> addNewInterceptorResourcetemplate() {
    return new InterceptorResourcetemplatesNested(-1, null);
  }
  
  public InterceptorResourcetemplatesNested<A> addNewInterceptorResourcetemplateLike(Interceptor item) {
    return new InterceptorResourcetemplatesNested(-1, item);
  }
  
  public InterceptorResourcetemplatesNested<A> setNewInterceptorResourcetemplateLike(int index,Interceptor item) {
    return new InterceptorResourcetemplatesNested(index, item);
  }
  
  public PersistentVolumeClaimResourcetemplatesNested<A> addNewPersistentVolumeClaimResourcetemplate() {
    return new PersistentVolumeClaimResourcetemplatesNested(-1, null);
  }
  
  public PersistentVolumeClaimResourcetemplatesNested<A> addNewPersistentVolumeClaimResourcetemplateLike(PersistentVolumeClaim item) {
    return new PersistentVolumeClaimResourcetemplatesNested(-1, item);
  }
  
  public PersistentVolumeClaimResourcetemplatesNested<A> setNewPersistentVolumeClaimResourcetemplateLike(int index,PersistentVolumeClaim item) {
    return new PersistentVolumeClaimResourcetemplatesNested(index, item);
  }
  
  public GenericKubernetesResourceResourcetemplatesNested<A> addNewGenericKubernetesResourceResourcetemplate() {
    return new GenericKubernetesResourceResourcetemplatesNested(-1, null);
  }
  
  public GenericKubernetesResourceResourcetemplatesNested<A> addNewGenericKubernetesResourceResourcetemplateLike(GenericKubernetesResource item) {
    return new GenericKubernetesResourceResourcetemplatesNested(-1, item);
  }
  
  public GenericKubernetesResourceResourcetemplatesNested<A> setNewGenericKubernetesResourceResourcetemplateLike(int index,GenericKubernetesResource item) {
    return new GenericKubernetesResourceResourcetemplatesNested(index, item);
  }
  
  public EventListenerResourcetemplatesNested<A> addNewEventListenerResourcetemplate() {
    return new EventListenerResourcetemplatesNested(-1, null);
  }
  
  public EventListenerResourcetemplatesNested<A> addNewEventListenerResourcetemplateLike(EventListener item) {
    return new EventListenerResourcetemplatesNested(-1, item);
  }
  
  public EventListenerResourcetemplatesNested<A> setNewEventListenerResourcetemplateLike(int index,EventListener item) {
    return new EventListenerResourcetemplatesNested(index, item);
  }
  
  public TriggerResourcetemplatesNested<A> addNewTriggerResourcetemplate() {
    return new TriggerResourcetemplatesNested(-1, null);
  }
  
  public TriggerResourcetemplatesNested<A> addNewTriggerResourcetemplateLike(Trigger item) {
    return new TriggerResourcetemplatesNested(-1, item);
  }
  
  public TriggerResourcetemplatesNested<A> setNewTriggerResourcetemplateLike(int index,Trigger item) {
    return new TriggerResourcetemplatesNested(index, item);
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    TriggerTemplateSpecFluent that = (TriggerTemplateSpecFluent) o;
    if (!java.util.Objects.equals(params, that.params)) return false;
    if (!java.util.Objects.equals(resourcetemplates, that.resourcetemplates)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(params,  resourcetemplates,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (params != null && !params.isEmpty()) { sb.append("params:"); sb.append(params + ","); }
    if (resourcetemplates != null && !resourcetemplates.isEmpty()) { sb.append("resourcetemplates:"); sb.append(resourcetemplates + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  protected static <T>VisitableBuilder<T,?> builder(Object item) {
    switch (item.getClass().getName()) {
    case "io.fabric8.tekton.triggers.v1alpha1."+"TriggerTemplate": return (VisitableBuilder<T, ?>)new TriggerTemplateBuilder((TriggerTemplate) item);
    case "io.fabric8.tekton.triggers.v1alpha1."+"ClusterInterceptor": return (VisitableBuilder<T, ?>)new ClusterInterceptorBuilder((ClusterInterceptor) item);
    case "io.fabric8.tekton.triggers.v1alpha1."+"TriggerBinding": return (VisitableBuilder<T, ?>)new TriggerBindingBuilder((TriggerBinding) item);
    case "io.fabric8.tekton.triggers.v1alpha1."+"ClusterTriggerBinding": return (VisitableBuilder<T, ?>)new ClusterTriggerBindingBuilder((ClusterTriggerBinding) item);
    case "io.fabric8.tekton.triggers.v1alpha1."+"Interceptor": return (VisitableBuilder<T, ?>)new InterceptorBuilder((Interceptor) item);
    case "io.fabric8.kubernetes.api.model."+"PersistentVolumeClaim": return (VisitableBuilder<T, ?>)new PersistentVolumeClaimBuilder((PersistentVolumeClaim) item);
    case "io.fabric8.kubernetes.api.model."+"GenericKubernetesResource": return (VisitableBuilder<T, ?>)new GenericKubernetesResourceBuilder((GenericKubernetesResource) item);
    case "io.fabric8.tekton.triggers.v1alpha1."+"EventListener": return (VisitableBuilder<T, ?>)new EventListenerBuilder((EventListener) item);
    case "io.fabric8.tekton.triggers.v1alpha1."+"Trigger": return (VisitableBuilder<T, ?>)new TriggerBuilder((Trigger) item);
    }
     return (VisitableBuilder<T, ?>)builderOf(item);
  }
  public class ParamsNested<N> extends ParamSpecFluent<ParamsNested<N>> implements Nested<N>{
    ParamsNested(int index,ParamSpec item) {
      this.index = index;
      this.builder = new ParamSpecBuilder(this, item);
    }
    ParamSpecBuilder builder;
    int index;
    
    public N and() {
      return (N) TriggerTemplateSpecFluent.this.setToParams(index,builder.build());
    }
    
    public N endParam() {
      return and();
    }
    
  
  }
  public class TriggerTemplateResourcetemplatesNested<N> extends TriggerTemplateFluent<TriggerTemplateResourcetemplatesNested<N>> implements Nested<N>{
    TriggerTemplateResourcetemplatesNested(int index,TriggerTemplate item) {
      this.index = index;
      this.builder = new TriggerTemplateBuilder(this, item);
    }
    TriggerTemplateBuilder builder;
    int index;
    
    public N and() {
      return (N) TriggerTemplateSpecFluent.this.setToResourcetemplates(index,builder.build());
    }
    
    public N endTriggerTemplateResourcetemplate() {
      return and();
    }
    
  
  }
  public class ClusterInterceptorResourcetemplatesNested<N> extends ClusterInterceptorFluent<ClusterInterceptorResourcetemplatesNested<N>> implements Nested<N>{
    ClusterInterceptorResourcetemplatesNested(int index,ClusterInterceptor item) {
      this.index = index;
      this.builder = new ClusterInterceptorBuilder(this, item);
    }
    ClusterInterceptorBuilder builder;
    int index;
    
    public N and() {
      return (N) TriggerTemplateSpecFluent.this.setToResourcetemplates(index,builder.build());
    }
    
    public N endClusterInterceptorResourcetemplate() {
      return and();
    }
    
  
  }
  public class TriggerBindingResourcetemplatesNested<N> extends TriggerBindingFluent<TriggerBindingResourcetemplatesNested<N>> implements Nested<N>{
    TriggerBindingResourcetemplatesNested(int index,TriggerBinding item) {
      this.index = index;
      this.builder = new TriggerBindingBuilder(this, item);
    }
    TriggerBindingBuilder builder;
    int index;
    
    public N and() {
      return (N) TriggerTemplateSpecFluent.this.setToResourcetemplates(index,builder.build());
    }
    
    public N endTriggerBindingResourcetemplate() {
      return and();
    }
    
  
  }
  public class ClusterTriggerBindingResourcetemplatesNested<N> extends ClusterTriggerBindingFluent<ClusterTriggerBindingResourcetemplatesNested<N>> implements Nested<N>{
    ClusterTriggerBindingResourcetemplatesNested(int index,ClusterTriggerBinding item) {
      this.index = index;
      this.builder = new ClusterTriggerBindingBuilder(this, item);
    }
    ClusterTriggerBindingBuilder builder;
    int index;
    
    public N and() {
      return (N) TriggerTemplateSpecFluent.this.setToResourcetemplates(index,builder.build());
    }
    
    public N endClusterTriggerBindingResourcetemplate() {
      return and();
    }
    
  
  }
  public class InterceptorResourcetemplatesNested<N> extends InterceptorFluent<InterceptorResourcetemplatesNested<N>> implements Nested<N>{
    InterceptorResourcetemplatesNested(int index,Interceptor item) {
      this.index = index;
      this.builder = new InterceptorBuilder(this, item);
    }
    InterceptorBuilder builder;
    int index;
    
    public N and() {
      return (N) TriggerTemplateSpecFluent.this.setToResourcetemplates(index,builder.build());
    }
    
    public N endInterceptorResourcetemplate() {
      return and();
    }
    
  
  }
  public class PersistentVolumeClaimResourcetemplatesNested<N> extends PersistentVolumeClaimFluent<PersistentVolumeClaimResourcetemplatesNested<N>> implements Nested<N>{
    PersistentVolumeClaimResourcetemplatesNested(int index,PersistentVolumeClaim item) {
      this.index = index;
      this.builder = new PersistentVolumeClaimBuilder(this, item);
    }
    PersistentVolumeClaimBuilder builder;
    int index;
    
    public N and() {
      return (N) TriggerTemplateSpecFluent.this.setToResourcetemplates(index,builder.build());
    }
    
    public N endPersistentVolumeClaimResourcetemplate() {
      return and();
    }
    
  
  }
  public class GenericKubernetesResourceResourcetemplatesNested<N> extends GenericKubernetesResourceFluent<GenericKubernetesResourceResourcetemplatesNested<N>> implements Nested<N>{
    GenericKubernetesResourceResourcetemplatesNested(int index,GenericKubernetesResource item) {
      this.index = index;
      this.builder = new GenericKubernetesResourceBuilder(this, item);
    }
    GenericKubernetesResourceBuilder builder;
    int index;
    
    public N and() {
      return (N) TriggerTemplateSpecFluent.this.setToResourcetemplates(index,builder.build());
    }
    
    public N endGenericKubernetesResourceResourcetemplate() {
      return and();
    }
    
  
  }
  public class EventListenerResourcetemplatesNested<N> extends EventListenerFluent<EventListenerResourcetemplatesNested<N>> implements Nested<N>{
    EventListenerResourcetemplatesNested(int index,EventListener item) {
      this.index = index;
      this.builder = new EventListenerBuilder(this, item);
    }
    EventListenerBuilder builder;
    int index;
    
    public N and() {
      return (N) TriggerTemplateSpecFluent.this.setToResourcetemplates(index,builder.build());
    }
    
    public N endEventListenerResourcetemplate() {
      return and();
    }
    
  
  }
  public class TriggerResourcetemplatesNested<N> extends TriggerFluent<TriggerResourcetemplatesNested<N>> implements Nested<N>{
    TriggerResourcetemplatesNested(int index,Trigger item) {
      this.index = index;
      this.builder = new TriggerBuilder(this, item);
    }
    TriggerBuilder builder;
    int index;
    
    public N and() {
      return (N) TriggerTemplateSpecFluent.this.setToResourcetemplates(index,builder.build());
    }
    
    public N endTriggerResourcetemplate() {
      return and();
    }
    
  
  }

}