/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.tekton.triggers.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.tekton.triggers.v1alpha1.CELInterceptor;
import io.fabric8.tekton.triggers.v1alpha1.CELOverlay;
import io.fabric8.tekton.triggers.v1alpha1.CELOverlayBuilder;
import io.fabric8.tekton.triggers.v1alpha1.CELOverlayFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class CELInterceptorFluent<A extends CELInterceptorFluent<A>>
extends BaseFluent<A> {
    private String filter;
    private ArrayList<CELOverlayBuilder> overlays = new ArrayList();
    private Map<String, Object> additionalProperties;

    public CELInterceptorFluent() {
    }

    public CELInterceptorFluent(CELInterceptor instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(CELInterceptor instance) {
        CELInterceptor cELInterceptor = instance = instance != null ? instance : new CELInterceptor();
        if (instance != null) {
            this.withFilter(instance.getFilter());
            this.withOverlays(instance.getOverlays());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getFilter() {
        return this.filter;
    }

    public A withFilter(String filter) {
        this.filter = filter;
        return (A)((Object)this);
    }

    public boolean hasFilter() {
        return this.filter != null;
    }

    public A addToOverlays(int index, CELOverlay item) {
        if (this.overlays == null) {
            this.overlays = new ArrayList();
        }
        CELOverlayBuilder builder = new CELOverlayBuilder(item);
        if (index < 0 || index >= this.overlays.size()) {
            this._visitables.get((Object)"overlays").add(builder);
            this.overlays.add(builder);
        } else {
            this._visitables.get((Object)"overlays").add(index, builder);
            this.overlays.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToOverlays(int index, CELOverlay item) {
        if (this.overlays == null) {
            this.overlays = new ArrayList();
        }
        CELOverlayBuilder builder = new CELOverlayBuilder(item);
        if (index < 0 || index >= this.overlays.size()) {
            this._visitables.get((Object)"overlays").add(builder);
            this.overlays.add(builder);
        } else {
            this._visitables.get((Object)"overlays").set(index, builder);
            this.overlays.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToOverlays(CELOverlay ... items) {
        if (this.overlays == null) {
            this.overlays = new ArrayList();
        }
        for (CELOverlay item : items) {
            CELOverlayBuilder builder = new CELOverlayBuilder(item);
            this._visitables.get((Object)"overlays").add(builder);
            this.overlays.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToOverlays(Collection<CELOverlay> items) {
        if (this.overlays == null) {
            this.overlays = new ArrayList();
        }
        for (CELOverlay item : items) {
            CELOverlayBuilder builder = new CELOverlayBuilder(item);
            this._visitables.get((Object)"overlays").add(builder);
            this.overlays.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromOverlays(CELOverlay ... items) {
        if (this.overlays == null) {
            return (A)((Object)this);
        }
        for (CELOverlay item : items) {
            CELOverlayBuilder builder = new CELOverlayBuilder(item);
            this._visitables.get((Object)"overlays").remove((Object)builder);
            this.overlays.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromOverlays(Collection<CELOverlay> items) {
        if (this.overlays == null) {
            return (A)((Object)this);
        }
        for (CELOverlay item : items) {
            CELOverlayBuilder builder = new CELOverlayBuilder(item);
            this._visitables.get((Object)"overlays").remove((Object)builder);
            this.overlays.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromOverlays(Predicate<CELOverlayBuilder> predicate) {
        if (this.overlays == null) {
            return (A)((Object)this);
        }
        Iterator<CELOverlayBuilder> each = this.overlays.iterator();
        List visitables = this._visitables.get((Object)"overlays");
        while (each.hasNext()) {
            CELOverlayBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<CELOverlay> buildOverlays() {
        return this.overlays != null ? CELInterceptorFluent.build(this.overlays) : null;
    }

    public CELOverlay buildOverlay(int index) {
        return this.overlays.get(index).build();
    }

    public CELOverlay buildFirstOverlay() {
        return this.overlays.get(0).build();
    }

    public CELOverlay buildLastOverlay() {
        return this.overlays.get(this.overlays.size() - 1).build();
    }

    public CELOverlay buildMatchingOverlay(Predicate<CELOverlayBuilder> predicate) {
        for (CELOverlayBuilder item : this.overlays) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingOverlay(Predicate<CELOverlayBuilder> predicate) {
        for (CELOverlayBuilder item : this.overlays) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withOverlays(List<CELOverlay> overlays) {
        if (this.overlays != null) {
            this._visitables.get((Object)"overlays").clear();
        }
        if (overlays != null) {
            this.overlays = new ArrayList();
            for (CELOverlay item : overlays) {
                this.addToOverlays(item);
            }
        } else {
            this.overlays = null;
        }
        return (A)((Object)this);
    }

    public A withOverlays(CELOverlay ... overlays) {
        if (this.overlays != null) {
            this.overlays.clear();
            this._visitables.remove((Object)"overlays");
        }
        if (overlays != null) {
            for (CELOverlay item : overlays) {
                this.addToOverlays(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasOverlays() {
        return this.overlays != null && !this.overlays.isEmpty();
    }

    public A addNewOverlay(String expression, String key) {
        return this.addToOverlays(new CELOverlay(expression, key));
    }

    public OverlaysNested<A> addNewOverlay() {
        return new OverlaysNested(-1, null);
    }

    public OverlaysNested<A> addNewOverlayLike(CELOverlay item) {
        return new OverlaysNested(-1, item);
    }

    public OverlaysNested<A> setNewOverlayLike(int index, CELOverlay item) {
        return new OverlaysNested(index, item);
    }

    public OverlaysNested<A> editOverlay(int index) {
        if (this.overlays.size() <= index) {
            throw new RuntimeException("Can't edit overlays. Index exceeds size.");
        }
        return this.setNewOverlayLike(index, this.buildOverlay(index));
    }

    public OverlaysNested<A> editFirstOverlay() {
        if (this.overlays.size() == 0) {
            throw new RuntimeException("Can't edit first overlays. The list is empty.");
        }
        return this.setNewOverlayLike(0, this.buildOverlay(0));
    }

    public OverlaysNested<A> editLastOverlay() {
        int index = this.overlays.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last overlays. The list is empty.");
        }
        return this.setNewOverlayLike(index, this.buildOverlay(index));
    }

    public OverlaysNested<A> editMatchingOverlay(Predicate<CELOverlayBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.overlays.size(); ++i) {
            if (!predicate.test(this.overlays.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching overlays. No match found.");
        }
        return this.setNewOverlayLike(index, this.buildOverlay(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CELInterceptorFluent that = (CELInterceptorFluent)((Object)o);
        if (!Objects.equals(this.filter, that.filter)) {
            return false;
        }
        if (!Objects.equals(this.overlays, that.overlays)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.filter, this.overlays, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.filter != null) {
            sb.append("filter:");
            sb.append(this.filter + ",");
        }
        if (this.overlays != null && !this.overlays.isEmpty()) {
            sb.append("overlays:");
            sb.append(this.overlays + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class OverlaysNested<N>
    extends CELOverlayFluent<OverlaysNested<N>>
    implements Nested<N> {
        CELOverlayBuilder builder;
        int index;

        OverlaysNested(int index, CELOverlay item) {
            this.index = index;
            this.builder = new CELOverlayBuilder(this, item);
        }

        public N and() {
            return (N)CELInterceptorFluent.this.setToOverlays(this.index, this.builder.build());
        }

        public N endOverlay() {
            return this.and();
        }
    }
}

