package io.fabric8.tekton.triggers.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelector;
import java.util.Collection;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class EventListenerSpecFluent<A extends EventListenerSpecFluent<A>> extends BaseFluent<A>{
  public EventListenerSpecFluent() {
  }
  
  public EventListenerSpecFluent(EventListenerSpec instance) {
    this.copyInstance(instance);
  }
  private LabelSelectorBuilder labelSelector;
  private NamespaceSelectorBuilder namespaceSelector;
  private ResourcesBuilder resources;
  private String serviceAccountName;
  private ArrayList<EventListenerTriggerBuilder> triggers = new ArrayList<EventListenerTriggerBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(EventListenerSpec instance) {
    instance = (instance != null ? instance : new EventListenerSpec());
    if (instance != null) {
          this.withLabelSelector(instance.getLabelSelector());
          this.withNamespaceSelector(instance.getNamespaceSelector());
          this.withResources(instance.getResources());
          this.withServiceAccountName(instance.getServiceAccountName());
          this.withTriggers(instance.getTriggers());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public LabelSelector buildLabelSelector() {
    return this.labelSelector != null ? this.labelSelector.build() : null;
  }
  
  public A withLabelSelector(LabelSelector labelSelector) {
    this._visitables.remove("labelSelector");
    if (labelSelector != null) {
        this.labelSelector = new LabelSelectorBuilder(labelSelector);
        this._visitables.get("labelSelector").add(this.labelSelector);
    } else {
        this.labelSelector = null;
        this._visitables.get("labelSelector").remove(this.labelSelector);
    }
    return (A) this;
  }
  
  public boolean hasLabelSelector() {
    return this.labelSelector != null;
  }
  
  public LabelSelectorNested<A> withNewLabelSelector() {
    return new LabelSelectorNested(null);
  }
  
  public LabelSelectorNested<A> withNewLabelSelectorLike(LabelSelector item) {
    return new LabelSelectorNested(item);
  }
  
  public LabelSelectorNested<A> editLabelSelector() {
    return withNewLabelSelectorLike(java.util.Optional.ofNullable(buildLabelSelector()).orElse(null));
  }
  
  public LabelSelectorNested<A> editOrNewLabelSelector() {
    return withNewLabelSelectorLike(java.util.Optional.ofNullable(buildLabelSelector()).orElse(new LabelSelectorBuilder().build()));
  }
  
  public LabelSelectorNested<A> editOrNewLabelSelectorLike(LabelSelector item) {
    return withNewLabelSelectorLike(java.util.Optional.ofNullable(buildLabelSelector()).orElse(item));
  }
  
  public NamespaceSelector buildNamespaceSelector() {
    return this.namespaceSelector != null ? this.namespaceSelector.build() : null;
  }
  
  public A withNamespaceSelector(NamespaceSelector namespaceSelector) {
    this._visitables.remove("namespaceSelector");
    if (namespaceSelector != null) {
        this.namespaceSelector = new NamespaceSelectorBuilder(namespaceSelector);
        this._visitables.get("namespaceSelector").add(this.namespaceSelector);
    } else {
        this.namespaceSelector = null;
        this._visitables.get("namespaceSelector").remove(this.namespaceSelector);
    }
    return (A) this;
  }
  
  public boolean hasNamespaceSelector() {
    return this.namespaceSelector != null;
  }
  
  public NamespaceSelectorNested<A> withNewNamespaceSelector() {
    return new NamespaceSelectorNested(null);
  }
  
  public NamespaceSelectorNested<A> withNewNamespaceSelectorLike(NamespaceSelector item) {
    return new NamespaceSelectorNested(item);
  }
  
  public NamespaceSelectorNested<A> editNamespaceSelector() {
    return withNewNamespaceSelectorLike(java.util.Optional.ofNullable(buildNamespaceSelector()).orElse(null));
  }
  
  public NamespaceSelectorNested<A> editOrNewNamespaceSelector() {
    return withNewNamespaceSelectorLike(java.util.Optional.ofNullable(buildNamespaceSelector()).orElse(new NamespaceSelectorBuilder().build()));
  }
  
  public NamespaceSelectorNested<A> editOrNewNamespaceSelectorLike(NamespaceSelector item) {
    return withNewNamespaceSelectorLike(java.util.Optional.ofNullable(buildNamespaceSelector()).orElse(item));
  }
  
  public Resources buildResources() {
    return this.resources != null ? this.resources.build() : null;
  }
  
  public A withResources(Resources resources) {
    this._visitables.remove("resources");
    if (resources != null) {
        this.resources = new ResourcesBuilder(resources);
        this._visitables.get("resources").add(this.resources);
    } else {
        this.resources = null;
        this._visitables.get("resources").remove(this.resources);
    }
    return (A) this;
  }
  
  public boolean hasResources() {
    return this.resources != null;
  }
  
  public ResourcesNested<A> withNewResources() {
    return new ResourcesNested(null);
  }
  
  public ResourcesNested<A> withNewResourcesLike(Resources item) {
    return new ResourcesNested(item);
  }
  
  public ResourcesNested<A> editResources() {
    return withNewResourcesLike(java.util.Optional.ofNullable(buildResources()).orElse(null));
  }
  
  public ResourcesNested<A> editOrNewResources() {
    return withNewResourcesLike(java.util.Optional.ofNullable(buildResources()).orElse(new ResourcesBuilder().build()));
  }
  
  public ResourcesNested<A> editOrNewResourcesLike(Resources item) {
    return withNewResourcesLike(java.util.Optional.ofNullable(buildResources()).orElse(item));
  }
  
  public String getServiceAccountName() {
    return this.serviceAccountName;
  }
  
  public A withServiceAccountName(String serviceAccountName) {
    this.serviceAccountName = serviceAccountName;
    return (A) this;
  }
  
  public boolean hasServiceAccountName() {
    return this.serviceAccountName != null;
  }
  
  public A addToTriggers(int index,EventListenerTrigger item) {
    if (this.triggers == null) {this.triggers = new ArrayList<EventListenerTriggerBuilder>();}
    EventListenerTriggerBuilder builder = new EventListenerTriggerBuilder(item);
    if (index < 0 || index >= triggers.size()) { _visitables.get("triggers").add(builder); triggers.add(builder); } else { _visitables.get("triggers").add(index, builder); triggers.add(index, builder);}
    return (A)this;
  }
  
  public A setToTriggers(int index,EventListenerTrigger item) {
    if (this.triggers == null) {this.triggers = new ArrayList<EventListenerTriggerBuilder>();}
    EventListenerTriggerBuilder builder = new EventListenerTriggerBuilder(item);
    if (index < 0 || index >= triggers.size()) { _visitables.get("triggers").add(builder); triggers.add(builder); } else { _visitables.get("triggers").set(index, builder); triggers.set(index, builder);}
    return (A)this;
  }
  
  public A addToTriggers(io.fabric8.tekton.triggers.v1alpha1.EventListenerTrigger... items) {
    if (this.triggers == null) {this.triggers = new ArrayList<EventListenerTriggerBuilder>();}
    for (EventListenerTrigger item : items) {EventListenerTriggerBuilder builder = new EventListenerTriggerBuilder(item);_visitables.get("triggers").add(builder);this.triggers.add(builder);} return (A)this;
  }
  
  public A addAllToTriggers(Collection<EventListenerTrigger> items) {
    if (this.triggers == null) {this.triggers = new ArrayList<EventListenerTriggerBuilder>();}
    for (EventListenerTrigger item : items) {EventListenerTriggerBuilder builder = new EventListenerTriggerBuilder(item);_visitables.get("triggers").add(builder);this.triggers.add(builder);} return (A)this;
  }
  
  public A removeFromTriggers(io.fabric8.tekton.triggers.v1alpha1.EventListenerTrigger... items) {
    if (this.triggers == null) return (A)this;
    for (EventListenerTrigger item : items) {EventListenerTriggerBuilder builder = new EventListenerTriggerBuilder(item);_visitables.get("triggers").remove(builder); this.triggers.remove(builder);} return (A)this;
  }
  
  public A removeAllFromTriggers(Collection<EventListenerTrigger> items) {
    if (this.triggers == null) return (A)this;
    for (EventListenerTrigger item : items) {EventListenerTriggerBuilder builder = new EventListenerTriggerBuilder(item);_visitables.get("triggers").remove(builder); this.triggers.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromTriggers(Predicate<EventListenerTriggerBuilder> predicate) {
    if (triggers == null) return (A) this;
    final Iterator<EventListenerTriggerBuilder> each = triggers.iterator();
    final List visitables = _visitables.get("triggers");
    while (each.hasNext()) {
      EventListenerTriggerBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<EventListenerTrigger> buildTriggers() {
    return this.triggers != null ? build(triggers) : null;
  }
  
  public EventListenerTrigger buildTrigger(int index) {
    return this.triggers.get(index).build();
  }
  
  public EventListenerTrigger buildFirstTrigger() {
    return this.triggers.get(0).build();
  }
  
  public EventListenerTrigger buildLastTrigger() {
    return this.triggers.get(triggers.size() - 1).build();
  }
  
  public EventListenerTrigger buildMatchingTrigger(Predicate<EventListenerTriggerBuilder> predicate) {
      for (EventListenerTriggerBuilder item : triggers) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingTrigger(Predicate<EventListenerTriggerBuilder> predicate) {
      for (EventListenerTriggerBuilder item : triggers) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withTriggers(List<EventListenerTrigger> triggers) {
    if (this.triggers != null) {
      this._visitables.get("triggers").clear();
    }
    if (triggers != null) {
        this.triggers = new ArrayList();
        for (EventListenerTrigger item : triggers) {
          this.addToTriggers(item);
        }
    } else {
      this.triggers = null;
    }
    return (A) this;
  }
  
  public A withTriggers(io.fabric8.tekton.triggers.v1alpha1.EventListenerTrigger... triggers) {
    if (this.triggers != null) {
        this.triggers.clear();
        _visitables.remove("triggers");
    }
    if (triggers != null) {
      for (EventListenerTrigger item : triggers) {
        this.addToTriggers(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasTriggers() {
    return this.triggers != null && !this.triggers.isEmpty();
  }
  
  public TriggersNested<A> addNewTrigger() {
    return new TriggersNested(-1, null);
  }
  
  public TriggersNested<A> addNewTriggerLike(EventListenerTrigger item) {
    return new TriggersNested(-1, item);
  }
  
  public TriggersNested<A> setNewTriggerLike(int index,EventListenerTrigger item) {
    return new TriggersNested(index, item);
  }
  
  public TriggersNested<A> editTrigger(int index) {
    if (triggers.size() <= index) throw new RuntimeException("Can't edit triggers. Index exceeds size.");
    return setNewTriggerLike(index, buildTrigger(index));
  }
  
  public TriggersNested<A> editFirstTrigger() {
    if (triggers.size() == 0) throw new RuntimeException("Can't edit first triggers. The list is empty.");
    return setNewTriggerLike(0, buildTrigger(0));
  }
  
  public TriggersNested<A> editLastTrigger() {
    int index = triggers.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last triggers. The list is empty.");
    return setNewTriggerLike(index, buildTrigger(index));
  }
  
  public TriggersNested<A> editMatchingTrigger(Predicate<EventListenerTriggerBuilder> predicate) {
    int index = -1;
    for (int i=0;i<triggers.size();i++) { 
    if (predicate.test(triggers.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching triggers. No match found.");
    return setNewTriggerLike(index, buildTrigger(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    EventListenerSpecFluent that = (EventListenerSpecFluent) o;
    if (!java.util.Objects.equals(labelSelector, that.labelSelector)) return false;
    if (!java.util.Objects.equals(namespaceSelector, that.namespaceSelector)) return false;
    if (!java.util.Objects.equals(resources, that.resources)) return false;
    if (!java.util.Objects.equals(serviceAccountName, that.serviceAccountName)) return false;
    if (!java.util.Objects.equals(triggers, that.triggers)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(labelSelector,  namespaceSelector,  resources,  serviceAccountName,  triggers,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (labelSelector != null) { sb.append("labelSelector:"); sb.append(labelSelector + ","); }
    if (namespaceSelector != null) { sb.append("namespaceSelector:"); sb.append(namespaceSelector + ","); }
    if (resources != null) { sb.append("resources:"); sb.append(resources + ","); }
    if (serviceAccountName != null) { sb.append("serviceAccountName:"); sb.append(serviceAccountName + ","); }
    if (triggers != null && !triggers.isEmpty()) { sb.append("triggers:"); sb.append(triggers + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class LabelSelectorNested<N> extends LabelSelectorFluent<LabelSelectorNested<N>> implements Nested<N>{
    LabelSelectorNested(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    LabelSelectorBuilder builder;
    
    public N and() {
      return (N) EventListenerSpecFluent.this.withLabelSelector(builder.build());
    }
    
    public N endLabelSelector() {
      return and();
    }
    
  
  }
  public class NamespaceSelectorNested<N> extends NamespaceSelectorFluent<NamespaceSelectorNested<N>> implements Nested<N>{
    NamespaceSelectorNested(NamespaceSelector item) {
      this.builder = new NamespaceSelectorBuilder(this, item);
    }
    NamespaceSelectorBuilder builder;
    
    public N and() {
      return (N) EventListenerSpecFluent.this.withNamespaceSelector(builder.build());
    }
    
    public N endNamespaceSelector() {
      return and();
    }
    
  
  }
  public class ResourcesNested<N> extends ResourcesFluent<ResourcesNested<N>> implements Nested<N>{
    ResourcesNested(Resources item) {
      this.builder = new ResourcesBuilder(this, item);
    }
    ResourcesBuilder builder;
    
    public N and() {
      return (N) EventListenerSpecFluent.this.withResources(builder.build());
    }
    
    public N endResources() {
      return and();
    }
    
  
  }
  public class TriggersNested<N> extends EventListenerTriggerFluent<TriggersNested<N>> implements Nested<N>{
    TriggersNested(int index,EventListenerTrigger item) {
      this.index = index;
      this.builder = new EventListenerTriggerBuilder(this, item);
    }
    EventListenerTriggerBuilder builder;
    int index;
    
    public N and() {
      return (N) EventListenerSpecFluent.this.setToTriggers(index,builder.build());
    }
    
    public N endTrigger() {
      return and();
    }
    
  
  }

}