
package io.fabric8.swagger.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import lombok.EqualsAndHashCode;
import lombok.ToString;

@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "swaggerVersion",
    "apis",
    "apiVersion",
    "info",
    "authorizations"
})
@ToString
@EqualsAndHashCode
public class ResourceListing {

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("swaggerVersion")
    @NotNull
    private ResourceListing.SwaggerVersion swaggerVersion;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("apis")
    @Valid
    @NotNull
    private List<Api_> apis = new ArrayList<Api_>();
    @JsonProperty("apiVersion")
    private String apiVersion;
    /**
     * info object (section 5.1.3)
     * 
     */
    @JsonProperty("info")
    @Valid
    private InfoObject info;
    @JsonProperty("authorizations")
    @Valid
    private Authorizations_ authorizations;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();

    /**
     * 
     * (Required)
     * 
     * @return
     *     The swaggerVersion
     */
    @JsonProperty("swaggerVersion")
    public ResourceListing.SwaggerVersion getSwaggerVersion() {
        return swaggerVersion;
    }

    /**
     * 
     * (Required)
     * 
     * @param swaggerVersion
     *     The swaggerVersion
     */
    @JsonProperty("swaggerVersion")
    public void setSwaggerVersion(ResourceListing.SwaggerVersion swaggerVersion) {
        this.swaggerVersion = swaggerVersion;
    }

    /**
     * 
     * (Required)
     * 
     * @return
     *     The apis
     */
    @JsonProperty("apis")
    public List<Api_> getApis() {
        return apis;
    }

    /**
     * 
     * (Required)
     * 
     * @param apis
     *     The apis
     */
    @JsonProperty("apis")
    public void setApis(List<Api_> apis) {
        this.apis = apis;
    }

    /**
     * 
     * @return
     *     The apiVersion
     */
    @JsonProperty("apiVersion")
    public String getApiVersion() {
        return apiVersion;
    }

    /**
     * 
     * @param apiVersion
     *     The apiVersion
     */
    @JsonProperty("apiVersion")
    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    /**
     * info object (section 5.1.3)
     * 
     * @return
     *     The info
     */
    @JsonProperty("info")
    public InfoObject getInfo() {
        return info;
    }

    /**
     * info object (section 5.1.3)
     * 
     * @param info
     *     The info
     */
    @JsonProperty("info")
    public void setInfo(InfoObject info) {
        this.info = info;
    }

    /**
     * 
     * @return
     *     The authorizations
     */
    @JsonProperty("authorizations")
    public Authorizations_ getAuthorizations() {
        return authorizations;
    }

    /**
     * 
     * @param authorizations
     *     The authorizations
     */
    @JsonProperty("authorizations")
    public void setAuthorizations(Authorizations_ authorizations) {
        this.authorizations = authorizations;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @SuppressWarnings({
        "unchecked"
    })
    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "swaggerVersion":
                if (value instanceof ResourceListing.SwaggerVersion) {
                    setSwaggerVersion(((ResourceListing.SwaggerVersion) value));
                } else {
                    throw new IllegalArgumentException(("property \"swaggerVersion\" is of type \"io.fabric8.swagger.model.ResourceListing.SwaggerVersion\", but got "+ value.getClass().toString()));
                }
                return true;
            case "apis":
                if (value instanceof List) {
                    setApis(((List<Api_> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"apis\" is of type \"java.util.List<io.fabric8.swagger.model.Api_>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "apiVersion":
                if (value instanceof String) {
                    setApiVersion(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"apiVersion\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "info":
                if (value instanceof InfoObject) {
                    setInfo(((InfoObject) value));
                } else {
                    throw new IllegalArgumentException(("property \"info\" is of type \"io.fabric8.swagger.model.InfoObject\", but got "+ value.getClass().toString()));
                }
                return true;
            case "authorizations":
                if (value instanceof Authorizations_) {
                    setAuthorizations(((Authorizations_) value));
                } else {
                    throw new IllegalArgumentException(("property \"authorizations\" is of type \"io.fabric8.swagger.model.Authorizations_\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "swaggerVersion":
                return getSwaggerVersion();
            case "apis":
                return getApis();
            case "apiVersion":
                return getApiVersion();
            case "info":
                return getInfo();
            case "authorizations":
                return getAuthorizations();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, ResourceListing.NOT_FOUND_VALUE);
        if (ResourceListing.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

    @Generated("org.jsonschema2pojo")
    public static enum SwaggerVersion {

        _1_2("1.2");
        private final String value;
        private final static Map<String, ResourceListing.SwaggerVersion> CONSTANTS = new HashMap<String, ResourceListing.SwaggerVersion>();

        static {
            for (ResourceListing.SwaggerVersion c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        private SwaggerVersion(String value) {
            this.value = value;
        }

        @JsonValue
        @Override
        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static ResourceListing.SwaggerVersion fromValue(String value) {
            ResourceListing.SwaggerVersion constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
