
package io.fabric8.swagger.model;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.Valid;
import javax.validation.constraints.Size;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * Data type fields (section 4.3.3)
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "type",
    "$ref",
    "format",
    "defaultValue",
    "enum",
    "minimum",
    "maximum",
    "items",
    "uniqueItems"
})
@ToString
@EqualsAndHashCode
public class DataTypeBase {

    @JsonProperty("type")
    private String type;
    @JsonProperty("$ref")
    private String $ref;
    @JsonProperty("format")
    private String format;
    @JsonProperty("defaultValue")
    private Object defaultValue;
    @JsonProperty("enum")
    @JsonDeserialize(as = java.util.LinkedHashSet.class)
    @Size(min = 1)
    @Valid
    private Set<String> _enum = new LinkedHashSet<String>();
    @JsonProperty("minimum")
    private String minimum;
    @JsonProperty("maximum")
    private String maximum;
    @JsonProperty("items")
    private Object items;
    @JsonProperty("uniqueItems")
    private Boolean uniqueItems;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected final static Object NOT_FOUND_VALUE = new Object();

    /**
     * 
     * @return
     *     The type
     */
    @JsonProperty("type")
    public String getType() {
        return type;
    }

    /**
     * 
     * @param type
     *     The type
     */
    @JsonProperty("type")
    public void setType(String type) {
        this.type = type;
    }

    /**
     * 
     * @return
     *     The $ref
     */
    @JsonProperty("$ref")
    public String get$ref() {
        return $ref;
    }

    /**
     * 
     * @param $ref
     *     The $ref
     */
    @JsonProperty("$ref")
    public void set$ref(String $ref) {
        this.$ref = $ref;
    }

    /**
     * 
     * @return
     *     The format
     */
    @JsonProperty("format")
    public String getFormat() {
        return format;
    }

    /**
     * 
     * @param format
     *     The format
     */
    @JsonProperty("format")
    public void setFormat(String format) {
        this.format = format;
    }

    /**
     * 
     * @return
     *     The defaultValue
     */
    @JsonProperty("defaultValue")
    public Object getDefaultValue() {
        return defaultValue;
    }

    /**
     * 
     * @param defaultValue
     *     The defaultValue
     */
    @JsonProperty("defaultValue")
    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    /**
     * 
     * @return
     *     The _enum
     */
    @JsonProperty("enum")
    public Set<String> getEnum() {
        return _enum;
    }

    /**
     * 
     * @param _enum
     *     The enum
     */
    @JsonProperty("enum")
    public void setEnum(Set<String> _enum) {
        this._enum = _enum;
    }

    /**
     * 
     * @return
     *     The minimum
     */
    @JsonProperty("minimum")
    public String getMinimum() {
        return minimum;
    }

    /**
     * 
     * @param minimum
     *     The minimum
     */
    @JsonProperty("minimum")
    public void setMinimum(String minimum) {
        this.minimum = minimum;
    }

    /**
     * 
     * @return
     *     The maximum
     */
    @JsonProperty("maximum")
    public String getMaximum() {
        return maximum;
    }

    /**
     * 
     * @param maximum
     *     The maximum
     */
    @JsonProperty("maximum")
    public void setMaximum(String maximum) {
        this.maximum = maximum;
    }

    /**
     * 
     * @return
     *     The items
     */
    @JsonProperty("items")
    public Object getItems() {
        return items;
    }

    /**
     * 
     * @param items
     *     The items
     */
    @JsonProperty("items")
    public void setItems(Object items) {
        this.items = items;
    }

    /**
     * 
     * @return
     *     The uniqueItems
     */
    @JsonProperty("uniqueItems")
    public Boolean getUniqueItems() {
        return uniqueItems;
    }

    /**
     * 
     * @param uniqueItems
     *     The uniqueItems
     */
    @JsonProperty("uniqueItems")
    public void setUniqueItems(Boolean uniqueItems) {
        this.uniqueItems = uniqueItems;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @SuppressWarnings({
        "unchecked"
    })
    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "type":
                if (value instanceof String) {
                    setType(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"type\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "$ref":
                if (value instanceof String) {
                    set$ref(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"$ref\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "format":
                if (value instanceof String) {
                    setFormat(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"format\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "defaultValue":
                if (value instanceof Object) {
                    setDefaultValue(((Object) value));
                } else {
                    throw new IllegalArgumentException(("property \"defaultValue\" is of type \"java.lang.Object\", but got "+ value.getClass().toString()));
                }
                return true;
            case "enum":
                if (value instanceof Set) {
                    setEnum(((Set<String> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"enum\" is of type \"java.util.Set<java.lang.String>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "minimum":
                if (value instanceof String) {
                    setMinimum(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"minimum\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "maximum":
                if (value instanceof String) {
                    setMaximum(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"maximum\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "items":
                if (value instanceof Object) {
                    setItems(((Object) value));
                } else {
                    throw new IllegalArgumentException(("property \"items\" is of type \"java.lang.Object\", but got "+ value.getClass().toString()));
                }
                return true;
            case "uniqueItems":
                if (value instanceof Boolean) {
                    setUniqueItems(((Boolean) value));
                } else {
                    throw new IllegalArgumentException(("property \"uniqueItems\" is of type \"java.lang.Boolean\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "type":
                return getType();
            case "$ref":
                return get$ref();
            case "format":
                return getFormat();
            case "defaultValue":
                return getDefaultValue();
            case "enum":
                return getEnum();
            case "minimum":
                return getMinimum();
            case "maximum":
                return getMaximum();
            case "items":
                return getItems();
            case "uniqueItems":
                return getUniqueItems();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, DataTypeBase.NOT_FOUND_VALUE);
        if (DataTypeBase.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            return ((T) getAdditionalProperties().get(name));
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            getAdditionalProperties().put(name, ((Object) value));
        }
    }

}
