
package io.fabric8.swagger.model;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import lombok.EqualsAndHashCode;
import lombok.ToString;

@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "swaggerVersion",
    "apiVersion",
    "basePath",
    "resourcePath",
    "apis",
    "models",
    "produces",
    "consumes",
    "authorizations"
})
@ToString
@EqualsAndHashCode
public class ApiDeclaration {

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("swaggerVersion")
    @NotNull
    private ApiDeclaration.SwaggerVersion swaggerVersion;
    @JsonProperty("apiVersion")
    private String apiVersion;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("basePath")
    @Pattern(regexp = "^https?://")
    @NotNull
    private URI basePath;
    @JsonProperty("resourcePath")
    @Pattern(regexp = "^/")
    private String resourcePath;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("apis")
    @Valid
    @NotNull
    private List<Api> apis = new ArrayList<Api>();
    @JsonProperty("models")
    @Valid
    private Models models;
    @JsonProperty("produces")
    @JsonDeserialize(as = java.util.LinkedHashSet.class)
    @Valid
    private Set<String> produces = new LinkedHashSet<String>();
    @JsonProperty("consumes")
    @JsonDeserialize(as = java.util.LinkedHashSet.class)
    @Valid
    private Set<String> consumes = new LinkedHashSet<String>();
    @JsonProperty("authorizations")
    @Valid
    private Authorizations_ authorizations;
    protected final static Object NOT_FOUND_VALUE = new Object();

    /**
     * 
     * (Required)
     * 
     * @return
     *     The swaggerVersion
     */
    @JsonProperty("swaggerVersion")
    public ApiDeclaration.SwaggerVersion getSwaggerVersion() {
        return swaggerVersion;
    }

    /**
     * 
     * (Required)
     * 
     * @param swaggerVersion
     *     The swaggerVersion
     */
    @JsonProperty("swaggerVersion")
    public void setSwaggerVersion(ApiDeclaration.SwaggerVersion swaggerVersion) {
        this.swaggerVersion = swaggerVersion;
    }

    /**
     * 
     * @return
     *     The apiVersion
     */
    @JsonProperty("apiVersion")
    public String getApiVersion() {
        return apiVersion;
    }

    /**
     * 
     * @param apiVersion
     *     The apiVersion
     */
    @JsonProperty("apiVersion")
    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    /**
     * 
     * (Required)
     * 
     * @return
     *     The basePath
     */
    @JsonProperty("basePath")
    public URI getBasePath() {
        return basePath;
    }

    /**
     * 
     * (Required)
     * 
     * @param basePath
     *     The basePath
     */
    @JsonProperty("basePath")
    public void setBasePath(URI basePath) {
        this.basePath = basePath;
    }

    /**
     * 
     * @return
     *     The resourcePath
     */
    @JsonProperty("resourcePath")
    public String getResourcePath() {
        return resourcePath;
    }

    /**
     * 
     * @param resourcePath
     *     The resourcePath
     */
    @JsonProperty("resourcePath")
    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    /**
     * 
     * (Required)
     * 
     * @return
     *     The apis
     */
    @JsonProperty("apis")
    public List<Api> getApis() {
        return apis;
    }

    /**
     * 
     * (Required)
     * 
     * @param apis
     *     The apis
     */
    @JsonProperty("apis")
    public void setApis(List<Api> apis) {
        this.apis = apis;
    }

    /**
     * 
     * @return
     *     The models
     */
    @JsonProperty("models")
    public Models getModels() {
        return models;
    }

    /**
     * 
     * @param models
     *     The models
     */
    @JsonProperty("models")
    public void setModels(Models models) {
        this.models = models;
    }

    /**
     * 
     * @return
     *     The produces
     */
    @JsonProperty("produces")
    public Set<String> getProduces() {
        return produces;
    }

    /**
     * 
     * @param produces
     *     The produces
     */
    @JsonProperty("produces")
    public void setProduces(Set<String> produces) {
        this.produces = produces;
    }

    /**
     * 
     * @return
     *     The consumes
     */
    @JsonProperty("consumes")
    public Set<String> getConsumes() {
        return consumes;
    }

    /**
     * 
     * @param consumes
     *     The consumes
     */
    @JsonProperty("consumes")
    public void setConsumes(Set<String> consumes) {
        this.consumes = consumes;
    }

    /**
     * 
     * @return
     *     The authorizations
     */
    @JsonProperty("authorizations")
    public Authorizations_ getAuthorizations() {
        return authorizations;
    }

    /**
     * 
     * @param authorizations
     *     The authorizations
     */
    @JsonProperty("authorizations")
    public void setAuthorizations(Authorizations_ authorizations) {
        this.authorizations = authorizations;
    }

    @SuppressWarnings({
        "unchecked"
    })
    protected boolean declaredProperty(String name, Object value) {
        switch (name) {
            case "swaggerVersion":
                if (value instanceof ApiDeclaration.SwaggerVersion) {
                    setSwaggerVersion(((ApiDeclaration.SwaggerVersion) value));
                } else {
                    throw new IllegalArgumentException(("property \"swaggerVersion\" is of type \"io.fabric8.swagger.model.ApiDeclaration.SwaggerVersion\", but got "+ value.getClass().toString()));
                }
                return true;
            case "apiVersion":
                if (value instanceof String) {
                    setApiVersion(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"apiVersion\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "basePath":
                if (value instanceof URI) {
                    setBasePath(((URI) value));
                } else {
                    throw new IllegalArgumentException(("property \"basePath\" is of type \"java.net.URI\", but got "+ value.getClass().toString()));
                }
                return true;
            case "resourcePath":
                if (value instanceof String) {
                    setResourcePath(((String) value));
                } else {
                    throw new IllegalArgumentException(("property \"resourcePath\" is of type \"java.lang.String\", but got "+ value.getClass().toString()));
                }
                return true;
            case "apis":
                if (value instanceof List) {
                    setApis(((List<Api> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"apis\" is of type \"java.util.List<io.fabric8.swagger.model.Api>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "models":
                if (value instanceof Models) {
                    setModels(((Models) value));
                } else {
                    throw new IllegalArgumentException(("property \"models\" is of type \"io.fabric8.swagger.model.Models\", but got "+ value.getClass().toString()));
                }
                return true;
            case "produces":
                if (value instanceof Set) {
                    setProduces(((Set<String> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"produces\" is of type \"java.util.Set<java.lang.String>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "consumes":
                if (value instanceof Set) {
                    setConsumes(((Set<String> ) value));
                } else {
                    throw new IllegalArgumentException(("property \"consumes\" is of type \"java.util.Set<java.lang.String>\", but got "+ value.getClass().toString()));
                }
                return true;
            case "authorizations":
                if (value instanceof Authorizations_) {
                    setAuthorizations(((Authorizations_) value));
                } else {
                    throw new IllegalArgumentException(("property \"authorizations\" is of type \"io.fabric8.swagger.model.Authorizations_\", but got "+ value.getClass().toString()));
                }
                return true;
            default:
                return false;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        switch (name) {
            case "swaggerVersion":
                return getSwaggerVersion();
            case "apiVersion":
                return getApiVersion();
            case "basePath":
                return getBasePath();
            case "resourcePath":
                return getResourcePath();
            case "apis":
                return getApis();
            case "models":
                return getModels();
            case "produces":
                return getProduces();
            case "consumes":
                return getConsumes();
            case "authorizations":
                return getAuthorizations();
            default:
                return notFoundValue;
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public<T >T get(String name) {
        Object value = declaredPropertyOrNotFound(name, ApiDeclaration.NOT_FOUND_VALUE);
        if (ApiDeclaration.NOT_FOUND_VALUE!= value) {
            return ((T) value);
        } else {
            throw new IllegalArgumentException((("property \""+ name)+"\" is not defined"));
        }
    }

    @SuppressWarnings({
        "unchecked"
    })
    public void set(String name, Object value) {
        if (!declaredProperty(name, value)) {
            throw new IllegalArgumentException((("property \""+ name)+"\" is not defined"));
        }
    }

    @Generated("org.jsonschema2pojo")
    public static enum SwaggerVersion {

        _1_2("1.2");
        private final String value;
        private final static Map<String, ApiDeclaration.SwaggerVersion> CONSTANTS = new HashMap<String, ApiDeclaration.SwaggerVersion>();

        static {
            for (ApiDeclaration.SwaggerVersion c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        private SwaggerVersion(String value) {
            this.value = value;
        }

        @JsonValue
        @Override
        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static ApiDeclaration.SwaggerVersion fromValue(String value) {
            ApiDeclaration.SwaggerVersion constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
