
package io.fabric8.swagger.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.Valid;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import lombok.EqualsAndHashCode;
import lombok.ToString;

@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "method",
    "summary",
    "notes",
    "nickname",
    "authorizations",
    "parameters",
    "responseMessages",
    "produces",
    "consumes",
    "deprecated"
})
@ToString
@EqualsAndHashCode
public class Operation {

    @JsonProperty("method")
    private Operation.Method method;
    @JsonProperty("summary")
    @Size(max = 120)
    private String summary;
    @JsonProperty("notes")
    private String notes;
    @JsonProperty("nickname")
    @Pattern(regexp = "^[a-zA-Z0-9_]+$")
    private String nickname;
    @JsonProperty("authorizations")
    @Valid
    private Authorizations authorizations;
    @JsonProperty("parameters")
    @Valid
    private List<Parameter> parameters = new ArrayList<Parameter>();
    @JsonProperty("responseMessages")
    @Valid
    private List<ResponseMessage> responseMessages = new ArrayList<ResponseMessage>();
    @JsonProperty("produces")
    @JsonDeserialize(as = java.util.LinkedHashSet.class)
    @Valid
    private Set<String> produces = new LinkedHashSet<String>();
    @JsonProperty("consumes")
    @JsonDeserialize(as = java.util.LinkedHashSet.class)
    @Valid
    private Set<String> consumes = new LinkedHashSet<String>();
    @JsonProperty("deprecated")
    private Operation.Deprecated deprecated;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * 
     * @return
     *     The method
     */
    @JsonProperty("method")
    public Operation.Method getMethod() {
        return method;
    }

    /**
     * 
     * @param method
     *     The method
     */
    @JsonProperty("method")
    public void setMethod(Operation.Method method) {
        this.method = method;
    }

    /**
     * 
     * @return
     *     The summary
     */
    @JsonProperty("summary")
    public String getSummary() {
        return summary;
    }

    /**
     * 
     * @param summary
     *     The summary
     */
    @JsonProperty("summary")
    public void setSummary(String summary) {
        this.summary = summary;
    }

    /**
     * 
     * @return
     *     The notes
     */
    @JsonProperty("notes")
    public String getNotes() {
        return notes;
    }

    /**
     * 
     * @param notes
     *     The notes
     */
    @JsonProperty("notes")
    public void setNotes(String notes) {
        this.notes = notes;
    }

    /**
     * 
     * @return
     *     The nickname
     */
    @JsonProperty("nickname")
    public String getNickname() {
        return nickname;
    }

    /**
     * 
     * @param nickname
     *     The nickname
     */
    @JsonProperty("nickname")
    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    /**
     * 
     * @return
     *     The authorizations
     */
    @JsonProperty("authorizations")
    public Authorizations getAuthorizations() {
        return authorizations;
    }

    /**
     * 
     * @param authorizations
     *     The authorizations
     */
    @JsonProperty("authorizations")
    public void setAuthorizations(Authorizations authorizations) {
        this.authorizations = authorizations;
    }

    /**
     * 
     * @return
     *     The parameters
     */
    @JsonProperty("parameters")
    public List<Parameter> getParameters() {
        return parameters;
    }

    /**
     * 
     * @param parameters
     *     The parameters
     */
    @JsonProperty("parameters")
    public void setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
    }

    /**
     * 
     * @return
     *     The responseMessages
     */
    @JsonProperty("responseMessages")
    public List<ResponseMessage> getResponseMessages() {
        return responseMessages;
    }

    /**
     * 
     * @param responseMessages
     *     The responseMessages
     */
    @JsonProperty("responseMessages")
    public void setResponseMessages(List<ResponseMessage> responseMessages) {
        this.responseMessages = responseMessages;
    }

    /**
     * 
     * @return
     *     The produces
     */
    @JsonProperty("produces")
    public Set<String> getProduces() {
        return produces;
    }

    /**
     * 
     * @param produces
     *     The produces
     */
    @JsonProperty("produces")
    public void setProduces(Set<String> produces) {
        this.produces = produces;
    }

    /**
     * 
     * @return
     *     The consumes
     */
    @JsonProperty("consumes")
    public Set<String> getConsumes() {
        return consumes;
    }

    /**
     * 
     * @param consumes
     *     The consumes
     */
    @JsonProperty("consumes")
    public void setConsumes(Set<String> consumes) {
        this.consumes = consumes;
    }

    /**
     * 
     * @return
     *     The deprecated
     */
    @JsonProperty("deprecated")
    public Operation.Deprecated getDeprecated() {
        return deprecated;
    }

    /**
     * 
     * @param deprecated
     *     The deprecated
     */
    @JsonProperty("deprecated")
    public void setDeprecated(Operation.Deprecated deprecated) {
        this.deprecated = deprecated;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @Generated("org.jsonschema2pojo")
    public static enum Deprecated {

        TRUE("true"),
        FALSE("false");
        private final String value;
        private final static Map<String, Operation.Deprecated> CONSTANTS = new HashMap<String, Operation.Deprecated>();

        static {
            for (Operation.Deprecated c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        private Deprecated(String value) {
            this.value = value;
        }

        @JsonValue
        @Override
        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Operation.Deprecated fromValue(String value) {
            Operation.Deprecated constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("org.jsonschema2pojo")
    public static enum Method {

        GET("GET"),
        HEAD("HEAD"),
        POST("POST"),
        PUT("PUT"),
        PATCH("PATCH"),
        DELETE("DELETE"),
        OPTIONS("OPTIONS");
        private final String value;
        private final static Map<String, Operation.Method> CONSTANTS = new HashMap<String, Operation.Method>();

        static {
            for (Operation.Method c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        private Method(String value) {
            this.value = value;
        }

        @JsonValue
        @Override
        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Operation.Method fromValue(String value) {
            Operation.Method constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
