
package io.fabric8.swagger.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import lombok.EqualsAndHashCode;
import lombok.ToString;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "swaggerVersion",
    "apis",
    "apiVersion",
    "info",
    "authorizations"
})
@ToString
@EqualsAndHashCode
public class ResourceListing {

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("swaggerVersion")
    @NotNull
    private ResourceListing.SwaggerVersion swaggerVersion;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("apis")
    @Valid
    @NotNull
    private List<Api_> apis = new ArrayList<Api_>();
    @JsonProperty("apiVersion")
    private String apiVersion;
    /**
     * info object (section 5.1.3)
     * 
     */
    @JsonProperty("info")
    @JsonPropertyDescription("info object (section 5.1.3)")
    @Valid
    private InfoObject info;
    @JsonProperty("authorizations")
    @Valid
    private Authorizations_ authorizations;
    @JsonIgnore
    @Valid
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("swaggerVersion")
    public ResourceListing.SwaggerVersion getSwaggerVersion() {
        return swaggerVersion;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("swaggerVersion")
    public void setSwaggerVersion(ResourceListing.SwaggerVersion swaggerVersion) {
        this.swaggerVersion = swaggerVersion;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("apis")
    public List<Api_> getApis() {
        return apis;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("apis")
    public void setApis(List<Api_> apis) {
        this.apis = apis;
    }

    @JsonProperty("apiVersion")
    public String getApiVersion() {
        return apiVersion;
    }

    @JsonProperty("apiVersion")
    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    /**
     * info object (section 5.1.3)
     * 
     */
    @JsonProperty("info")
    public InfoObject getInfo() {
        return info;
    }

    /**
     * info object (section 5.1.3)
     * 
     */
    @JsonProperty("info")
    public void setInfo(InfoObject info) {
        this.info = info;
    }

    @JsonProperty("authorizations")
    public Authorizations_ getAuthorizations() {
        return authorizations;
    }

    @JsonProperty("authorizations")
    public void setAuthorizations(Authorizations_ authorizations) {
        this.authorizations = authorizations;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public enum SwaggerVersion {

        _1_2("1.2");
        private final String value;
        private final static Map<String, ResourceListing.SwaggerVersion> CONSTANTS = new HashMap<String, ResourceListing.SwaggerVersion>();

        static {
            for (ResourceListing.SwaggerVersion c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        private SwaggerVersion(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static ResourceListing.SwaggerVersion fromValue(String value) {
            ResourceListing.SwaggerVersion constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
