
package io.fabric8.swagger.model;

import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import lombok.EqualsAndHashCode;
import lombok.ToString;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "implicit",
    "authorization_code"
})
@ToString
@EqualsAndHashCode
public class Oauth2GrantType {

    @JsonProperty("implicit")
    @Valid
    private Implicit implicit;
    @JsonProperty("authorization_code")
    @Valid
    private AuthorizationCode authorizationCode;
    @JsonIgnore
    @Valid
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    @JsonProperty("implicit")
    public Implicit getImplicit() {
        return implicit;
    }

    @JsonProperty("implicit")
    public void setImplicit(Implicit implicit) {
        this.implicit = implicit;
    }

    @JsonProperty("authorization_code")
    public AuthorizationCode getAuthorizationCode() {
        return authorizationCode;
    }

    @JsonProperty("authorization_code")
    public void setAuthorizationCode(AuthorizationCode authorizationCode) {
        this.authorizationCode = authorizationCode;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
