
package io.fabric8.swagger.model;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import lombok.EqualsAndHashCode;
import lombok.ToString;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "swaggerVersion",
    "apiVersion",
    "basePath",
    "resourcePath",
    "apis",
    "models",
    "produces",
    "consumes",
    "authorizations"
})
@ToString
@EqualsAndHashCode
public class ApiDeclaration {

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("swaggerVersion")
    @NotNull
    private ApiDeclaration.SwaggerVersion swaggerVersion;
    @JsonProperty("apiVersion")
    private String apiVersion;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("basePath")
    @Pattern(regexp = "^https?://")
    @NotNull
    private URI basePath;
    @JsonProperty("resourcePath")
    @Pattern(regexp = "^/")
    private String resourcePath;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("apis")
    @Valid
    @NotNull
    private List<Api> apis = new ArrayList<Api>();
    @JsonProperty("models")
    @Valid
    private Models models;
    @JsonProperty("produces")
    @JsonDeserialize(as = java.util.LinkedHashSet.class)
    @Valid
    private Set<String> produces = new LinkedHashSet<String>();
    @JsonProperty("consumes")
    @JsonDeserialize(as = java.util.LinkedHashSet.class)
    @Valid
    private Set<String> consumes = new LinkedHashSet<String>();
    @JsonProperty("authorizations")
    @Valid
    private Authorizations_ authorizations;

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("swaggerVersion")
    public ApiDeclaration.SwaggerVersion getSwaggerVersion() {
        return swaggerVersion;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("swaggerVersion")
    public void setSwaggerVersion(ApiDeclaration.SwaggerVersion swaggerVersion) {
        this.swaggerVersion = swaggerVersion;
    }

    @JsonProperty("apiVersion")
    public String getApiVersion() {
        return apiVersion;
    }

    @JsonProperty("apiVersion")
    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("basePath")
    public URI getBasePath() {
        return basePath;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("basePath")
    public void setBasePath(URI basePath) {
        this.basePath = basePath;
    }

    @JsonProperty("resourcePath")
    public String getResourcePath() {
        return resourcePath;
    }

    @JsonProperty("resourcePath")
    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("apis")
    public List<Api> getApis() {
        return apis;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("apis")
    public void setApis(List<Api> apis) {
        this.apis = apis;
    }

    @JsonProperty("models")
    public Models getModels() {
        return models;
    }

    @JsonProperty("models")
    public void setModels(Models models) {
        this.models = models;
    }

    @JsonProperty("produces")
    public Set<String> getProduces() {
        return produces;
    }

    @JsonProperty("produces")
    public void setProduces(Set<String> produces) {
        this.produces = produces;
    }

    @JsonProperty("consumes")
    public Set<String> getConsumes() {
        return consumes;
    }

    @JsonProperty("consumes")
    public void setConsumes(Set<String> consumes) {
        this.consumes = consumes;
    }

    @JsonProperty("authorizations")
    public Authorizations_ getAuthorizations() {
        return authorizations;
    }

    @JsonProperty("authorizations")
    public void setAuthorizations(Authorizations_ authorizations) {
        this.authorizations = authorizations;
    }

    public enum SwaggerVersion {

        _1_2("1.2");
        private final String value;
        private final static Map<String, ApiDeclaration.SwaggerVersion> CONSTANTS = new HashMap<String, ApiDeclaration.SwaggerVersion>();

        static {
            for (ApiDeclaration.SwaggerVersion c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        private SwaggerVersion(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static ApiDeclaration.SwaggerVersion fromValue(String value) {
            ApiDeclaration.SwaggerVersion constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
