
package io.fabric8.swagger.model;

import java.net.URI;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import lombok.EqualsAndHashCode;
import lombok.ToString;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "url",
    "tokenName"
})
@ToString
@EqualsAndHashCode
public class TokenEndpoint {

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("url")
    @NotNull
    private URI url;
    @JsonProperty("tokenName")
    private String tokenName;

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("url")
    public URI getUrl() {
        return url;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("url")
    public void setUrl(URI url) {
        this.url = url;
    }

    @JsonProperty("tokenName")
    public String getTokenName() {
        return tokenName;
    }

    @JsonProperty("tokenName")
    public void setTokenName(String tokenName) {
        this.tokenName = tokenName;
    }

}
