
package io.fabric8.swagger.model;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import lombok.EqualsAndHashCode;
import lombok.ToString;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "tokenEndpoint",
    "tokenRequestEndpoint"
})
@ToString
@EqualsAndHashCode
public class AuthorizationCode {

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("tokenEndpoint")
    @Valid
    @NotNull
    private TokenEndpoint tokenEndpoint;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("tokenRequestEndpoint")
    @Valid
    @NotNull
    private TokenRequestEndpoint tokenRequestEndpoint;

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("tokenEndpoint")
    public TokenEndpoint getTokenEndpoint() {
        return tokenEndpoint;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("tokenEndpoint")
    public void setTokenEndpoint(TokenEndpoint tokenEndpoint) {
        this.tokenEndpoint = tokenEndpoint;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("tokenRequestEndpoint")
    public TokenRequestEndpoint getTokenRequestEndpoint() {
        return tokenRequestEndpoint;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("tokenRequestEndpoint")
    public void setTokenRequestEndpoint(TokenRequestEndpoint tokenRequestEndpoint) {
        this.tokenRequestEndpoint = tokenRequestEndpoint;
    }

}
