
package io.fabric8.swagger.model;

import java.net.URI;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import lombok.EqualsAndHashCode;
import lombok.ToString;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "url",
    "clientIdName",
    "clientSecretName"
})
@ToString
@EqualsAndHashCode
public class TokenRequestEndpoint {

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("url")
    @NotNull
    private URI url;
    @JsonProperty("clientIdName")
    private String clientIdName;
    @JsonProperty("clientSecretName")
    private String clientSecretName;

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("url")
    public URI getUrl() {
        return url;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("url")
    public void setUrl(URI url) {
        this.url = url;
    }

    @JsonProperty("clientIdName")
    public String getClientIdName() {
        return clientIdName;
    }

    @JsonProperty("clientIdName")
    public void setClientIdName(String clientIdName) {
        this.clientIdName = clientIdName;
    }

    @JsonProperty("clientSecretName")
    public String getClientSecretName() {
        return clientSecretName;
    }

    @JsonProperty("clientSecretName")
    public void setClientSecretName(String clientSecretName) {
        this.clientSecretName = clientSecretName;
    }

}
