
package io.fabric8.swagger.model;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import lombok.EqualsAndHashCode;
import lombok.ToString;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "loginEndpoint",
    "tokenName"
})
@ToString
@EqualsAndHashCode
public class Implicit {

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("loginEndpoint")
    @Valid
    @NotNull
    private LoginEndpoint loginEndpoint;
    @JsonProperty("tokenName")
    private String tokenName;

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("loginEndpoint")
    public LoginEndpoint getLoginEndpoint() {
        return loginEndpoint;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("loginEndpoint")
    public void setLoginEndpoint(LoginEndpoint loginEndpoint) {
        this.loginEndpoint = loginEndpoint;
    }

    @JsonProperty("tokenName")
    public String getTokenName() {
        return tokenName;
    }

    @JsonProperty("tokenName")
    public void setTokenName(String tokenName) {
        this.tokenName = tokenName;
    }

}
