
package io.fabric8.swagger.model;

import java.net.URI;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * info object (section 5.1.3)
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "title",
    "description",
    "termsOfServiceUrl",
    "contact",
    "license",
    "licenseUrl"
})
@ToString
@EqualsAndHashCode
public class InfoObject {

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("title")
    @NotNull
    private String title;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("description")
    @NotNull
    private String description;
    @JsonProperty("termsOfServiceUrl")
    private URI termsOfServiceUrl;
    @JsonProperty("contact")
    private String contact;
    @JsonProperty("license")
    private String license;
    @JsonProperty("licenseUrl")
    private URI licenseUrl;

    /**
     * 
     * (Required)
     * 
     * @return
     *     The title
     */
    @JsonProperty("title")
    public String getTitle() {
        return title;
    }

    /**
     * 
     * (Required)
     * 
     * @param title
     *     The title
     */
    @JsonProperty("title")
    public void setTitle(String title) {
        this.title = title;
    }

    /**
     * 
     * (Required)
     * 
     * @return
     *     The description
     */
    @JsonProperty("description")
    public String getDescription() {
        return description;
    }

    /**
     * 
     * (Required)
     * 
     * @param description
     *     The description
     */
    @JsonProperty("description")
    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * 
     * @return
     *     The termsOfServiceUrl
     */
    @JsonProperty("termsOfServiceUrl")
    public URI getTermsOfServiceUrl() {
        return termsOfServiceUrl;
    }

    /**
     * 
     * @param termsOfServiceUrl
     *     The termsOfServiceUrl
     */
    @JsonProperty("termsOfServiceUrl")
    public void setTermsOfServiceUrl(URI termsOfServiceUrl) {
        this.termsOfServiceUrl = termsOfServiceUrl;
    }

    /**
     * 
     * @return
     *     The contact
     */
    @JsonProperty("contact")
    public String getContact() {
        return contact;
    }

    /**
     * 
     * @param contact
     *     The contact
     */
    @JsonProperty("contact")
    public void setContact(String contact) {
        this.contact = contact;
    }

    /**
     * 
     * @return
     *     The license
     */
    @JsonProperty("license")
    public String getLicense() {
        return license;
    }

    /**
     * 
     * @param license
     *     The license
     */
    @JsonProperty("license")
    public void setLicense(String license) {
        this.license = license;
    }

    /**
     * 
     * @return
     *     The licenseUrl
     */
    @JsonProperty("licenseUrl")
    public URI getLicenseUrl() {
        return licenseUrl;
    }

    /**
     * 
     * @param licenseUrl
     *     The licenseUrl
     */
    @JsonProperty("licenseUrl")
    public void setLicenseUrl(URI licenseUrl) {
        this.licenseUrl = licenseUrl;
    }

}
