
package io.fabric8.swagger.model;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Generated;
import javax.validation.Valid;
import javax.validation.constraints.Size;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * Data type fields (section 4.3.3)
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "type",
    "$ref",
    "format",
    "defaultValue",
    "enum",
    "minimum",
    "maximum",
    "items",
    "uniqueItems"
})
@ToString
@EqualsAndHashCode
public class DataTypeBase {

    @JsonProperty("type")
    private String type;
    @JsonProperty("$ref")
    private String $ref;
    @JsonProperty("format")
    private String format;
    @JsonProperty("defaultValue")
    private Object defaultValue;
    @JsonProperty("enum")
    @JsonDeserialize(as = java.util.LinkedHashSet.class)
    @Size(min = 1)
    @Valid
    private Set<String> _enum = new LinkedHashSet<String>();
    @JsonProperty("minimum")
    private String minimum;
    @JsonProperty("maximum")
    private String maximum;
    @JsonProperty("items")
    private Object items;
    @JsonProperty("uniqueItems")
    private Boolean uniqueItems;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * 
     * @return
     *     The type
     */
    @JsonProperty("type")
    public String getType() {
        return type;
    }

    /**
     * 
     * @param type
     *     The type
     */
    @JsonProperty("type")
    public void setType(String type) {
        this.type = type;
    }

    /**
     * 
     * @return
     *     The $ref
     */
    @JsonProperty("$ref")
    public String get$ref() {
        return $ref;
    }

    /**
     * 
     * @param $ref
     *     The $ref
     */
    @JsonProperty("$ref")
    public void set$ref(String $ref) {
        this.$ref = $ref;
    }

    /**
     * 
     * @return
     *     The format
     */
    @JsonProperty("format")
    public String getFormat() {
        return format;
    }

    /**
     * 
     * @param format
     *     The format
     */
    @JsonProperty("format")
    public void setFormat(String format) {
        this.format = format;
    }

    /**
     * 
     * @return
     *     The defaultValue
     */
    @JsonProperty("defaultValue")
    public Object getDefaultValue() {
        return defaultValue;
    }

    /**
     * 
     * @param defaultValue
     *     The defaultValue
     */
    @JsonProperty("defaultValue")
    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    /**
     * 
     * @return
     *     The _enum
     */
    @JsonProperty("enum")
    public Set<String> getEnum() {
        return _enum;
    }

    /**
     * 
     * @param _enum
     *     The enum
     */
    @JsonProperty("enum")
    public void setEnum(Set<String> _enum) {
        this._enum = _enum;
    }

    /**
     * 
     * @return
     *     The minimum
     */
    @JsonProperty("minimum")
    public String getMinimum() {
        return minimum;
    }

    /**
     * 
     * @param minimum
     *     The minimum
     */
    @JsonProperty("minimum")
    public void setMinimum(String minimum) {
        this.minimum = minimum;
    }

    /**
     * 
     * @return
     *     The maximum
     */
    @JsonProperty("maximum")
    public String getMaximum() {
        return maximum;
    }

    /**
     * 
     * @param maximum
     *     The maximum
     */
    @JsonProperty("maximum")
    public void setMaximum(String maximum) {
        this.maximum = maximum;
    }

    /**
     * 
     * @return
     *     The items
     */
    @JsonProperty("items")
    public Object getItems() {
        return items;
    }

    /**
     * 
     * @param items
     *     The items
     */
    @JsonProperty("items")
    public void setItems(Object items) {
        this.items = items;
    }

    /**
     * 
     * @return
     *     The uniqueItems
     */
    @JsonProperty("uniqueItems")
    public Boolean getUniqueItems() {
        return uniqueItems;
    }

    /**
     * 
     * @param uniqueItems
     *     The uniqueItems
     */
    @JsonProperty("uniqueItems")
    public void setUniqueItems(Boolean uniqueItems) {
        this.uniqueItems = uniqueItems;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
