/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.swagger.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.swagger.model.Authorizations;
import io.fabric8.swagger.model.Parameter;
import io.fabric8.swagger.model.ResponseMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.Valid;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"method", "summary", "notes", "nickname", "authorizations", "parameters", "responseMessages", "produces", "consumes", "deprecated"})
public class Operation {
    @JsonProperty(value="method")
    private Method method;
    @JsonProperty(value="summary")
    @Size(max=120)
    private String summary;
    @JsonProperty(value="notes")
    private String notes;
    @JsonProperty(value="nickname")
    @Pattern(regexp="^[a-zA-Z0-9_]+$")
    private String nickname;
    @JsonProperty(value="authorizations")
    @Valid
    private Authorizations authorizations;
    @JsonProperty(value="parameters")
    @Valid
    private List<Parameter> parameters = new ArrayList<Parameter>();
    @JsonProperty(value="responseMessages")
    @Valid
    private List<ResponseMessage> responseMessages = new ArrayList<ResponseMessage>();
    @JsonProperty(value="produces")
    @JsonDeserialize(as=LinkedHashSet.class)
    @Valid
    private Set<String> produces = new LinkedHashSet<String>();
    @JsonProperty(value="consumes")
    @JsonDeserialize(as=LinkedHashSet.class)
    @Valid
    private Set<String> consumes = new LinkedHashSet<String>();
    @JsonProperty(value="deprecated")
    private Deprecated deprecated;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    @JsonProperty(value="method")
    public Method getMethod() {
        return this.method;
    }

    @JsonProperty(value="method")
    public void setMethod(Method method) {
        this.method = method;
    }

    @JsonProperty(value="summary")
    public String getSummary() {
        return this.summary;
    }

    @JsonProperty(value="summary")
    public void setSummary(String summary) {
        this.summary = summary;
    }

    @JsonProperty(value="notes")
    public String getNotes() {
        return this.notes;
    }

    @JsonProperty(value="notes")
    public void setNotes(String notes) {
        this.notes = notes;
    }

    @JsonProperty(value="nickname")
    public String getNickname() {
        return this.nickname;
    }

    @JsonProperty(value="nickname")
    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    @JsonProperty(value="authorizations")
    public Authorizations getAuthorizations() {
        return this.authorizations;
    }

    @JsonProperty(value="authorizations")
    public void setAuthorizations(Authorizations authorizations) {
        this.authorizations = authorizations;
    }

    @JsonProperty(value="parameters")
    public List<Parameter> getParameters() {
        return this.parameters;
    }

    @JsonProperty(value="parameters")
    public void setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
    }

    @JsonProperty(value="responseMessages")
    public List<ResponseMessage> getResponseMessages() {
        return this.responseMessages;
    }

    @JsonProperty(value="responseMessages")
    public void setResponseMessages(List<ResponseMessage> responseMessages) {
        this.responseMessages = responseMessages;
    }

    @JsonProperty(value="produces")
    public Set<String> getProduces() {
        return this.produces;
    }

    @JsonProperty(value="produces")
    public void setProduces(Set<String> produces) {
        this.produces = produces;
    }

    @JsonProperty(value="consumes")
    public Set<String> getConsumes() {
        return this.consumes;
    }

    @JsonProperty(value="consumes")
    public void setConsumes(Set<String> consumes) {
        this.consumes = consumes;
    }

    @JsonProperty(value="deprecated")
    public Deprecated getDeprecated() {
        return this.deprecated;
    }

    @JsonProperty(value="deprecated")
    public void setDeprecated(Deprecated deprecated) {
        this.deprecated = deprecated;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    public boolean equals(Object other) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public static enum Method {
        GET("GET"),
        HEAD("HEAD"),
        POST("POST"),
        PUT("PUT"),
        PATCH("PATCH"),
        DELETE("DELETE"),
        OPTIONS("OPTIONS");

        private final String value;
        private static Map<String, Method> constants;

        private Method(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Method fromValue(String value) {
            Method constant = constants.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            constants = new HashMap<String, Method>();
            for (Method c : Method.values()) {
                constants.put(c.value, c);
            }
        }
    }

    public static enum Deprecated {
        TRUE("true"),
        FALSE("false");

        private final String value;
        private static Map<String, Deprecated> constants;

        private Deprecated(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Deprecated fromValue(String value) {
            Deprecated constant = constants.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            constants = new HashMap<String, Deprecated>();
            for (Deprecated c : Deprecated.values()) {
                constants.put(c.value, c);
            }
        }
    }
}

