
package io.fabric8.swagger.model;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "paramType",
    "name",
    "type",
    "description",
    "required",
    "allowMultiple",
    "consumes"
})
public class Parameter {

    @JsonProperty("paramType")
    private Parameter.ParamType paramType;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("name")
    @NotNull
    private String name;
    @JsonProperty("type")
    private String type;
    @JsonProperty("description")
    private String description;
    @JsonProperty("required")
    private Boolean required;
    @JsonProperty("allowMultiple")
    private Boolean allowMultiple;
    @JsonProperty("consumes")
    private Parameter.Consumes consumes;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * 
     * @return
     *     The paramType
     */
    @JsonProperty("paramType")
    public Parameter.ParamType getParamType() {
        return paramType;
    }

    /**
     * 
     * @param paramType
     *     The paramType
     */
    @JsonProperty("paramType")
    public void setParamType(Parameter.ParamType paramType) {
        this.paramType = paramType;
    }

    /**
     * 
     * (Required)
     * 
     * @return
     *     The name
     */
    @JsonProperty("name")
    public String getName() {
        return name;
    }

    /**
     * 
     * (Required)
     * 
     * @param name
     *     The name
     */
    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    /**
     * 
     * @return
     *     The type
     */
    @JsonProperty("type")
    public String getType() {
        return type;
    }

    /**
     * 
     * @param type
     *     The type
     */
    @JsonProperty("type")
    public void setType(String type) {
        this.type = type;
    }

    /**
     * 
     * @return
     *     The description
     */
    @JsonProperty("description")
    public String getDescription() {
        return description;
    }

    /**
     * 
     * @param description
     *     The description
     */
    @JsonProperty("description")
    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * 
     * @return
     *     The required
     */
    @JsonProperty("required")
    public Boolean getRequired() {
        return required;
    }

    /**
     * 
     * @param required
     *     The required
     */
    @JsonProperty("required")
    public void setRequired(Boolean required) {
        this.required = required;
    }

    /**
     * 
     * @return
     *     The allowMultiple
     */
    @JsonProperty("allowMultiple")
    public Boolean getAllowMultiple() {
        return allowMultiple;
    }

    /**
     * 
     * @param allowMultiple
     *     The allowMultiple
     */
    @JsonProperty("allowMultiple")
    public void setAllowMultiple(Boolean allowMultiple) {
        this.allowMultiple = allowMultiple;
    }

    /**
     * 
     * @return
     *     The consumes
     */
    @JsonProperty("consumes")
    public Parameter.Consumes getConsumes() {
        return consumes;
    }

    /**
     * 
     * @param consumes
     *     The consumes
     */
    @JsonProperty("consumes")
    public void setConsumes(Parameter.Consumes consumes) {
        this.consumes = consumes;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    @Override
    public boolean equals(Object other) {
        return EqualsBuilder.reflectionEquals(this, other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @Generated("org.jsonschema2pojo")
    public static enum Consumes {

        MULTIPART_FORM_DATA("multipart/form-data");
        private final String value;
        private static Map<String, Parameter.Consumes> constants = new HashMap<String, Parameter.Consumes>();

        static {
            for (Parameter.Consumes c: values()) {
                constants.put(c.value, c);
            }
        }

        private Consumes(String value) {
            this.value = value;
        }

        @JsonValue
        @Override
        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Parameter.Consumes fromValue(String value) {
            Parameter.Consumes constant = constants.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("org.jsonschema2pojo")
    public static enum ParamType {

        PATH("path"),
        QUERY("query"),
        BODY("body"),
        HEADER("header"),
        FORM("form");
        private final String value;
        private static Map<String, Parameter.ParamType> constants = new HashMap<String, Parameter.ParamType>();

        static {
            for (Parameter.ParamType c: values()) {
                constants.put(c.value, c);
            }
        }

        private ParamType(String value) {
            this.value = value;
        }

        @JsonValue
        @Override
        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Parameter.ParamType fromValue(String value) {
            Parameter.ParamType constant = constants.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
