/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.spring.cloud.kubernetes.zipkin;

import io.fabric8.spring.cloud.kubernetes.zipkin.KubernetesZipkinDiscoveryProperties;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.sleuth.metric.SpanMetricReporter;
import org.springframework.cloud.sleuth.zipkin.HttpZipkinSpanReporter;
import org.springframework.cloud.sleuth.zipkin.ZipkinAutoConfiguration;
import org.springframework.cloud.sleuth.zipkin.ZipkinProperties;
import org.springframework.cloud.sleuth.zipkin.ZipkinSpanReporter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import zipkin.Span;

@Configuration
@EnableConfigurationProperties(value={KubernetesZipkinDiscoveryProperties.class})
@ConditionalOnProperty(value={"spring.cloud.kubernetes.zipkin.discovery.enabled"}, matchIfMissing=true)
@AutoConfigureBefore(value={ZipkinAutoConfiguration.class})
public class ZipkinKubernetesAutoConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZipkinKubernetesAutoConfiguration.class);

    @Bean
    public ZipkinSpanReporter reporter(DiscoveryClient discoveryClient, KubernetesZipkinDiscoveryProperties discoveryProperties, SpanMetricReporter spanMetricReporter, ZipkinProperties zipkin) {
        String serviceName = discoveryProperties.getServiceName();
        List services = discoveryClient.getInstances(serviceName);
        String serviceUrl = services.stream().findFirst().map(s -> s.getUri().toString()).orElse(null);
        LOGGER.warn("No service with name: [" + serviceName + "] found. Falling back to NullZipkinSpanReporter.");
        return serviceUrl == null || serviceUrl.isEmpty() ? new NullZipkinSpanReporter() : new HttpZipkinSpanReporter(serviceUrl, zipkin.getFlushInterval(), zipkin.getCompression().isEnabled(), spanMetricReporter);
    }

    static final class NullZipkinSpanReporter
    implements ZipkinSpanReporter {
        NullZipkinSpanReporter() {
        }

        public void report(Span span) {
        }
    }
}

