/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.spring.cloud.kubernetes.zipkin;

import io.fabric8.spring.cloud.kubernetes.zipkin.KubernetesZipkinDiscoveryProperties;
import java.util.List;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.sleuth.metric.SpanMetricReporter;
import org.springframework.cloud.sleuth.zipkin.HttpZipkinSpanReporter;
import org.springframework.cloud.sleuth.zipkin.ZipkinAutoConfiguration;
import org.springframework.cloud.sleuth.zipkin.ZipkinProperties;
import org.springframework.cloud.sleuth.zipkin.ZipkinSpanReporter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={KubernetesZipkinDiscoveryProperties.class})
@ConditionalOnProperty(value={"spring.cloud.kubernetes.zipkin.discovery.enabled"}, matchIfMissing=true)
@AutoConfigureBefore(value={ZipkinAutoConfiguration.class})
public class ZipkinKubernetesAutoConfiguration {
    @Bean
    public ZipkinSpanReporter reporter(DiscoveryClient discoveryClient, KubernetesZipkinDiscoveryProperties discoveryProperties, SpanMetricReporter spanMetricReporter, ZipkinProperties zipkin) {
        String serviceName = discoveryProperties.getServiceName();
        List services = discoveryClient.getInstances(serviceName);
        String serviceUrl = services.stream().findFirst().map(s -> s.getUri().toString()).orElseThrow(() -> new IllegalStateException("No ZipKin Query Api found with service id: [" + serviceName + "]."));
        return new HttpZipkinSpanReporter(serviceUrl, zipkin.getFlushInterval(), zipkin.getCompression().isEnabled(), spanMetricReporter);
    }
}

