/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.spring.cloud.kubernetes.zipkin;

import io.fabric8.kubernetes.api.model.EndpointPort;
import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ClientResource;
import io.fabric8.kubernetes.client.utils.Utils;
import io.fabric8.spring.cloud.discovery.KubernetesServiceInstance;
import io.fabric8.spring.cloud.kubernetes.zipkin.KubernetesZipkinDiscoveryProperties;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.sleuth.metric.SpanMetricReporter;
import org.springframework.cloud.sleuth.zipkin.HttpZipkinSpanReporter;
import org.springframework.cloud.sleuth.zipkin.ZipkinAutoConfiguration;
import org.springframework.cloud.sleuth.zipkin.ZipkinProperties;
import org.springframework.cloud.sleuth.zipkin.ZipkinSpanReporter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.Assert;
import zipkin.Span;

@Configuration
@EnableConfigurationProperties(value={KubernetesZipkinDiscoveryProperties.class})
@ConditionalOnProperty(value={"spring.cloud.kubernetes.zipkin.discovery.enabled"}, matchIfMissing=true)
@AutoConfigureBefore(value={ZipkinAutoConfiguration.class})
public class ZipkinKubernetesAutoConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZipkinKubernetesAutoConfiguration.class);

    @Bean
    public ZipkinSpanReporter reporter(KubernetesClient client, KubernetesZipkinDiscoveryProperties discoveryProperties, SpanMetricReporter spanMetricReporter, ZipkinProperties zipkin) {
        String serviceName = discoveryProperties.getServiceName();
        String serviceNamespace = Utils.isNotNullOrEmpty((String)discoveryProperties.getServiceNamespace()) ? discoveryProperties.getServiceNamespace() : client.getNamespace();
        List<ServiceInstance> services = ZipkinKubernetesAutoConfiguration.getInstances(client, serviceName, serviceNamespace);
        String serviceUrl = services.stream().findFirst().map(s -> s.getUri().toString()).orElse(null);
        return serviceUrl == null || serviceUrl.isEmpty() ? new NullZipkinSpanReporter() : new HttpZipkinSpanReporter(serviceUrl, zipkin.getFlushInterval(), zipkin.getCompression().isEnabled(), spanMetricReporter);
    }

    private static List<ServiceInstance> getInstances(KubernetesClient client, String name, String namespace) {
        Assert.notNull((Object)name, (String)"[Assertion failed] - the service name must not be null");
        return ((Endpoints)Optional.ofNullable(((ClientResource)((ClientNonNamespaceOperation)client.endpoints().inNamespace(namespace)).withName(name)).get()).orElse(new Endpoints())).getSubsets().stream().map(s -> new KubernetesServiceInstance(name, ((EndpointPort)s.getPorts().iterator().next()).getName(), s, Boolean.valueOf(false))).collect(Collectors.toList());
    }

    static final class NullZipkinSpanReporter
    implements ZipkinSpanReporter {
        NullZipkinSpanReporter() {
        }

        public void report(Span span) {
        }
    }
}

