/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.spring.cloud.kubernetes.ribbon;

import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import com.netflix.client.config.IClientConfigKey;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;

public abstract class KubernetesConfigKey<T>
implements IClientConfigKey<T> {
    public static final IClientConfigKey<String> Namespace = new KubernetesConfigKey<String>("KubernetesNamespace"){};
    public static final IClientConfigKey<String> PortName = new KubernetesConfigKey<String>("PortName"){};
    private static final Set<IClientConfigKey> keys = new HashSet<IClientConfigKey>();
    private final String configKey;
    private final Class<T> type;

    @Deprecated
    public static IClientConfigKey[] values() {
        return KubernetesConfigKey.keys().toArray(new IClientConfigKey[0]);
    }

    public static Set<IClientConfigKey> keys() {
        return keys;
    }

    public static IClientConfigKey valueOf(final String name) {
        for (IClientConfigKey key : KubernetesConfigKey.keys()) {
            if (!key.key().equals(name)) continue;
            return key;
        }
        return new IClientConfigKey(){

            public String key() {
                return name;
            }

            public Class type() {
                return String.class;
            }
        };
    }

    protected KubernetesConfigKey(String configKey) {
        this.configKey = configKey;
        Type superclass = this.getClass().getGenericSuperclass();
        Preconditions.checkArgument((boolean)(superclass instanceof ParameterizedType), (String)"%s isn't parameterized", (Object[])new Object[]{superclass});
        Type runtimeType = ((ParameterizedType)superclass).getActualTypeArguments()[0];
        this.type = TypeToken.of((Type)runtimeType).getRawType();
    }

    public Class<T> type() {
        return this.type;
    }

    public String key() {
        return this.configKey;
    }

    public String toString() {
        return this.configKey;
    }

    static {
        for (Field f : KubernetesConfigKey.class.getDeclaredFields()) {
            if (!Modifier.isStatic(f.getModifiers()) || !IClientConfigKey.class.isAssignableFrom(f.getType())) continue;
            try {
                keys.add((IClientConfigKey)f.get(null));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

