/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.spring.cloud.discovery;

import io.fabric8.kubernetes.api.model.EndpointAddress;
import io.fabric8.kubernetes.api.model.EndpointPort;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Map;
import org.springframework.cloud.client.ServiceInstance;

public class KubernetesServiceInstance
implements ServiceInstance {
    private static final String HTTP_PREFIX = "http://";
    private static final String HTTPS_PREFIX = "https://";
    private static final String COLN = ":";
    private final String serviceId;
    private final EndpointAddress endpointAddress;
    private final EndpointPort endpointPort;
    private final Boolean secure;

    public KubernetesServiceInstance(String serviceId, EndpointAddress endpointAddress, EndpointPort endpointPort, Boolean secure) {
        this.serviceId = serviceId;
        this.endpointAddress = endpointAddress;
        this.endpointPort = endpointPort;
        this.secure = secure;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public String getHost() {
        return this.endpointAddress.getIp();
    }

    public int getPort() {
        return this.endpointPort.getPort();
    }

    public boolean isSecure() {
        return this.secure;
    }

    public URI getUri() {
        StringBuilder sb = new StringBuilder();
        if (this.isSecure()) {
            sb.append(HTTPS_PREFIX);
        } else {
            sb.append(HTTP_PREFIX);
        }
        sb.append(this.getHost()).append(COLN).append(this.getPort());
        try {
            return new URI(sb.toString());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public Map<String, String> getMetadata() {
        return Collections.EMPTY_MAP;
    }
}

