/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.spring.cloud.discovery;

import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.spring.cloud.discovery.KubernetesDiscoveryClient;
import io.fabric8.spring.cloud.discovery.KubernetesDiscoveryLifecycle;
import io.fabric8.spring.cloud.discovery.KubernetesDiscoveryProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={KubernetesDiscoveryProperties.class})
@ConditionalOnProperty(value={"spring.cloud.kubernetes.discovery.enabled"}, matchIfMissing=true)
public class KubernetesDiscoveryClientConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public KubernetesDiscoveryClient kubernetesDiscoveryClient(KubernetesClient client, KubernetesDiscoveryProperties properties) {
        return new KubernetesDiscoveryClient(client, properties);
    }

    @Bean
    public KubernetesDiscoveryLifecycle kubernetesDiscoveryLifecycle(KubernetesClient client, KubernetesDiscoveryProperties properties) {
        return new KubernetesDiscoveryLifecycle(client, properties);
    }
}

