/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.spring.cloud.discovery;

import io.fabric8.kubernetes.api.model.EndpointAddress;
import io.fabric8.kubernetes.api.model.EndpointPort;
import io.fabric8.kubernetes.api.model.EndpointSubset;
import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.api.model.ServiceList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.ClientResource;
import io.fabric8.kubernetes.client.utils.Utils;
import io.fabric8.spring.cloud.discovery.KubernetesDiscoveryProperties;
import io.fabric8.spring.cloud.discovery.KubernetesServiceInstance;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.cloud.client.DefaultServiceInstance;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.util.Assert;

public class KubernetesDiscoveryClient
implements DiscoveryClient {
    private static final String HOSTNAME = "HOSTNAME";
    private KubernetesClient client;
    private KubernetesDiscoveryProperties properties;

    public KubernetesDiscoveryClient(KubernetesClient client, KubernetesDiscoveryProperties properties) {
        this.client = client;
        this.properties = properties;
    }

    public KubernetesClient getClient() {
        return this.client;
    }

    public void setClient(KubernetesClient client) {
        this.client = client;
    }

    public String description() {
        return "Kubernetes Discovery Client";
    }

    public ServiceInstance getLocalServiceInstance() {
        String serviceName = this.properties.getServiceName();
        String podName = System.getenv(HOSTNAME);
        Endpoints endpoints = (Endpoints)((ClientResource)this.client.endpoints().withName(serviceName)).get();
        if (Utils.isNullOrEmpty((String)podName) || endpoints == null) {
            return new DefaultServiceInstance(serviceName, "localhost", 8080, false);
        }
        return endpoints.getSubsets().stream().filter(s -> ((EndpointAddress)s.getAddresses().iterator().next()).getIp().equals(podName)).map(s -> new KubernetesServiceInstance(serviceName, ((EndpointPort)s.getPorts().iterator().next()).getName(), (EndpointSubset)s, false)).findFirst().get();
    }

    public List<ServiceInstance> getInstances(String serviceId) {
        Assert.notNull((Object)serviceId, (String)"[Assertion failed] - the object argument must be null");
        return ((Endpoints)Optional.ofNullable(((ClientResource)this.client.endpoints().withName(serviceId)).get()).orElse(new Endpoints())).getSubsets().stream().map(s -> new KubernetesServiceInstance(serviceId, ((EndpointPort)s.getPorts().iterator().next()).getName(), (EndpointSubset)s, false)).collect(Collectors.toList());
    }

    public List<String> getServices() {
        return ((ServiceList)this.client.services().list()).getItems().stream().map(s -> s.getMetadata().getName()).collect(Collectors.toList());
    }
}

