/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.spring.cloud.discovery;

import io.fabric8.kubernetes.api.model.EndpointAddress;
import io.fabric8.kubernetes.api.model.EndpointPort;
import io.fabric8.kubernetes.api.model.EndpointSubset;
import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.api.model.ServiceList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.ClientResource;
import io.fabric8.spring.cloud.discovery.KubernetesServiceInstance;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;

public class KubernetesDiscoveryClient
implements DiscoveryClient {
    private static final String HOSTNAME = "HOSTNAME";
    private KubernetesClient client;
    private String localServiceId;

    public KubernetesDiscoveryClient(KubernetesClient client, String localServiceId) {
        this.client = client;
        this.localServiceId = localServiceId;
    }

    public KubernetesClient getClient() {
        return this.client;
    }

    public void setClient(KubernetesClient client) {
        this.client = client;
    }

    public String getLocalServiceId() {
        return this.localServiceId;
    }

    public void setLocalServiceId(String localServiceId) {
        this.localServiceId = localServiceId;
    }

    public String description() {
        return "Kubernetes Discovery Client";
    }

    public ServiceInstance getLocalServiceInstance() {
        String podName = System.getenv(HOSTNAME);
        return ((Endpoints)((ClientResource)this.client.endpoints().withName(this.localServiceId)).get()).getSubsets().stream().filter(s -> ((EndpointAddress)s.getAddresses().iterator().next()).getIp().equals(podName)).map(s -> new KubernetesServiceInstance(this.localServiceId, ((EndpointPort)s.getPorts().iterator().next()).getName(), (EndpointSubset)s, false)).findFirst().get();
    }

    public List<ServiceInstance> getInstances(String serviceId) {
        return ((Endpoints)((ClientResource)this.client.endpoints().withName(serviceId)).get()).getSubsets().stream().map(s -> new KubernetesServiceInstance(serviceId, ((EndpointPort)s.getPorts().iterator().next()).getName(), (EndpointSubset)s, false)).collect(Collectors.toList());
    }

    public List<String> getServices() {
        return ((ServiceList)this.client.services().list()).getItems().stream().map(s -> s.getMetadata().getName()).collect(Collectors.toList());
    }
}

