/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.spring.cloud.discovery;

import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.spring.cloud.discovery.KubernetesDiscoveryProperties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.cloud.client.discovery.AbstractDiscoveryLifecycle;
import org.springframework.cloud.client.discovery.event.InstanceRegisteredEvent;
import org.springframework.context.ApplicationEvent;

public class KubernetesDiscoveryLifecycle
extends AbstractDiscoveryLifecycle {
    private KubernetesClient client;
    private KubernetesDiscoveryProperties properties;
    private AtomicBoolean running = new AtomicBoolean(false);

    public KubernetesDiscoveryLifecycle(KubernetesClient client, KubernetesDiscoveryProperties properties) {
        this.client = client;
        this.properties = properties;
    }

    public void start() {
        if (!this.isEnabled()) {
            return;
        }
        if (!this.isRunning()) {
            this.register();
            this.getContext().publishEvent((ApplicationEvent)new InstanceRegisteredEvent((Object)this, this.getConfiguration()));
            this.running.compareAndSet(false, true);
        }
    }

    public boolean isRunning() {
        return this.running.get();
    }

    protected int getConfiguredPort() {
        return this.client.getMasterUrl().getPort();
    }

    protected void setConfiguredPort(int port) {
    }

    protected Object getConfiguration() {
        return this.properties;
    }

    protected void register() {
    }

    protected void deregister() {
    }

    protected boolean isEnabled() {
        return this.properties.isEnabled();
    }
}

