/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.spring.cloud.discovery;

import io.fabric8.kubernetes.api.model.EndpointAddress;
import io.fabric8.kubernetes.api.model.EndpointPort;
import io.fabric8.kubernetes.api.model.EndpointSubset;
import io.fabric8.kubernetes.client.utils.Utils;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Map;
import org.springframework.cloud.client.ServiceInstance;

public class KubernetesServiceInstance
implements ServiceInstance {
    private static final String HTTP_PREFIX = "http://";
    private static final String HTTPS_PREFIX = "https://";
    private static final String COLN = ":";
    private final String serviceId;
    private final String portName;
    private final EndpointSubset subset;
    private final Boolean secure;

    public KubernetesServiceInstance(String serviceId, String portName, EndpointSubset subset, Boolean secure) {
        this.serviceId = serviceId;
        this.portName = portName;
        this.subset = subset;
        this.secure = secure;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public String getHost() {
        if (this.subset.getAddresses().isEmpty()) {
            throw new IllegalStateException("Endpoint subset has no addresses.");
        }
        return ((EndpointAddress)this.subset.getAddresses().get(0)).getIp();
    }

    public int getPort() {
        if (this.subset.getPorts().isEmpty()) {
            throw new IllegalStateException("Endpoint subset has no ports.");
        }
        if (Utils.isNullOrEmpty((String)this.portName) && this.subset.getPorts().size() == 1) {
            return ((EndpointPort)this.subset.getPorts().get(0)).getPort();
        }
        if (Utils.isNotNullOrEmpty((String)this.portName)) {
            for (EndpointPort port : this.subset.getPorts()) {
                if (!this.portName.endsWith(port.getName())) continue;
                return port.getPort();
            }
        }
        throw new IllegalStateException("Endpoint subset has no matching ports.");
    }

    public boolean isSecure() {
        return this.secure;
    }

    public URI getUri() {
        StringBuilder sb = new StringBuilder();
        if (this.isSecure()) {
            sb.append(HTTPS_PREFIX);
        } else {
            sb.append(HTTP_PREFIX);
        }
        sb.append(this.getHost()).append(COLN).append(this.getPort());
        try {
            return new URI(sb.toString());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public Map<String, String> getMetadata() {
        return Collections.EMPTY_MAP;
    }
}

