/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.spring.cloud.kubernetes.config;

import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.SecretList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.spring.cloud.kubernetes.config.ConfigUtils;
import io.fabric8.spring.cloud.kubernetes.config.SecretsConfigProperties;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.util.StringUtils;

public class SecretsPropertySource
extends MapPropertySource {
    private static final Logger LOGGER = LoggerFactory.getLogger(SecretsPropertySource.class);
    private static final String PREFIX = "secrets";

    public SecretsPropertySource(KubernetesClient client, Environment env, SecretsConfigProperties config) {
        super(SecretsPropertySource.getSourceName(client, env, config), SecretsPropertySource.getSourceData(client, env, config));
    }

    private static String getSourceName(KubernetesClient client, Environment env, SecretsConfigProperties config) {
        return PREFIX + "." + ConfigUtils.getApplicationName(env, config) + "." + ConfigUtils.getApplicationNamespace(client, env, config);
    }

    private static Map<String, Object> getSourceData(KubernetesClient client, Environment env, SecretsConfigProperties config) {
        String name = ConfigUtils.getApplicationName(env, config);
        String namespace = ConfigUtils.getApplicationNamespace(client, env, config);
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (config.isEnableApi()) {
            try {
                if (StringUtils.isEmpty((Object)namespace)) {
                    SecretsPropertySource.putAll((Secret)((Resource)client.secrets().withName(name)).get(), result);
                } else {
                    SecretsPropertySource.putAll((Secret)((Resource)((NonNamespaceOperation)client.secrets().inNamespace(namespace)).withName(name)).get(), result);
                }
                if (!config.getLabels().isEmpty()) {
                    if (StringUtils.isEmpty((Object)namespace)) {
                        ((SecretList)((FilterWatchListDeletable)client.secrets().withLabels(config.getLabels())).list()).getItems().forEach(s -> SecretsPropertySource.putAll(s, (Map<String, Object>)result));
                    } else {
                        ((SecretList)((FilterWatchListDeletable)((NonNamespaceOperation)client.secrets().inNamespace(namespace)).withLabels(config.getLabels())).list()).getItems().forEach(s -> SecretsPropertySource.putAll(s, (Map<String, Object>)result));
                    }
                }
            }
            catch (Exception e) {
                LOGGER.warn("Can't read secret with name: [{}] or labels [{}] in namespace:[{}] (cause: {}). Ignoring", new Object[]{name, config.getLabels(), namespace, e.getMessage()});
            }
        }
        config.getPaths().stream().map(x$0 -> Paths.get(x$0, new String[0])).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).forEach(p -> SecretsPropertySource.putAll(p, (Map<String, Object>)result));
        return result;
    }

    private static void putAll(Secret secret, Map<String, Object> result) {
        if (secret != null && secret.getData() != null) {
            secret.getData().forEach((k, v) -> result.put((String)k, new String(Base64.getDecoder().decode((String)v)).trim()));
        }
    }

    private static void putAll(Path path, Map<String, Object> result) {
        try {
            Files.walk(path, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(p -> SecretsPropertySource.readFile(p, result));
        }
        catch (IOException e) {
            LOGGER.warn("", (Throwable)e);
        }
    }

    private static void readFile(Path path, Map<String, Object> result) {
        try {
            result.put(path.getFileName().toString(), new String(Files.readAllBytes(path)).trim());
        }
        catch (IOException e) {
            LOGGER.warn("", (Throwable)e);
        }
    }
}

