/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.spring.cloud.kubernetes.config;

import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.spring.cloud.kubernetes.config.AbstractConfigProperties;
import io.fabric8.spring.cloud.kubernetes.config.SecretsPropertySource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

public class ConfigUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(SecretsPropertySource.class);

    public static <C extends AbstractConfigProperties> String getApplicationName(Environment env, C config) {
        String name = config.getName();
        if (StringUtils.isEmpty((Object)name)) {
            LOGGER.debug(config.getConfigurationTarget() + " name has not been set, taking it from property/env {} (default={})", (Object)"spring.application.name", (Object)"application");
            name = env.getProperty("spring.application.name", "application");
        }
        return name;
    }

    public static <C extends AbstractConfigProperties> String getApplicationNamespace(KubernetesClient client, Environment env, C config) {
        String namespace = config.getNamespace();
        if (StringUtils.isEmpty((Object)namespace)) {
            LOGGER.debug(config.getConfigurationTarget() + " namespace has not been set, taking it from client (ns={})", (Object)client.getNamespace());
            namespace = client.getNamespace();
        }
        return namespace;
    }
}

