/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.spring.cloud.kubernetes.config;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.spring.cloud.kubernetes.KubernetesAutoConfiguration;
import io.fabric8.spring.cloud.kubernetes.config.ConfigMapConfigProperties;
import io.fabric8.spring.cloud.kubernetes.config.ConfigMapPropertySourceLocator;
import io.fabric8.spring.cloud.kubernetes.config.SecretsConfigProperties;
import io.fabric8.spring.cloud.kubernetes.config.SecretsPropertySourceLocator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@ConditionalOnProperty(value={"spring.cloud.kubernetes.enabled"}, matchIfMissing=true)
@ConditionalOnClass(value={ConfigMap.class, Secret.class})
public class BootstrapConfiguration {

    @Configuration
    @Import(value={KubernetesAutoConfiguration.class})
    @EnableConfigurationProperties(value={ConfigMapConfigProperties.class, SecretsConfigProperties.class})
    @ConditionalOnProperty(name={"spring.cloud.kubernetes.config.enabled"}, matchIfMissing=true)
    protected static class KubernetesPropertySourceConfiguration {
        @Autowired
        private KubernetesClient client;

        protected KubernetesPropertySourceConfiguration() {
        }

        @Bean
        public ConfigMapPropertySourceLocator configMapPropertySourceLocator(ConfigMapConfigProperties properties) {
            return new ConfigMapPropertySourceLocator(this.client, properties);
        }

        @Bean
        public SecretsPropertySourceLocator secretsPropertySourceLocator(SecretsConfigProperties properties) {
            return new SecretsPropertySourceLocator(this.client, properties);
        }
    }
}

