/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.spring.cloud.kubernetes.reload;

import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.spring.cloud.kubernetes.reload.ConfigReloadProperties;
import io.fabric8.spring.cloud.kubernetes.reload.ConfigurationUpdateStrategy;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

public abstract class ConfigurationChangeDetector {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    protected ConfigurableEnvironment environment;
    protected ConfigReloadProperties properties;
    protected KubernetesClient kubernetesClient;
    protected ConfigurationUpdateStrategy strategy;

    public ConfigurationChangeDetector(ConfigurableEnvironment environment, ConfigReloadProperties properties, KubernetesClient kubernetesClient, ConfigurationUpdateStrategy strategy) {
        this.environment = environment;
        this.properties = properties;
        this.kubernetesClient = kubernetesClient;
        this.strategy = strategy;
    }

    @PreDestroy
    public void shutdown() {
        this.kubernetesClient.close();
    }

    public void reloadProperties() {
        this.log.info("Reloading using strategy: " + this.strategy.getName());
        this.strategy.reload();
    }

    protected boolean changed(MapPropertySource mp1, MapPropertySource mp2) {
        if (mp1 == mp2) {
            return false;
        }
        if (mp1 == null && mp2 != null || mp1 != null && mp2 == null) {
            return true;
        }
        Map s1 = (Map)mp1.getSource();
        Map s2 = (Map)mp2.getSource();
        return s1 == null ? s2 != null : !s1.equals(s2);
    }

    protected <S extends PropertySource<?>> S findPropertySource(Class<S> sourceClass) {
        List<S> sources = this.findPropertySources(sourceClass);
        if (sources.size() == 0) {
            return null;
        }
        if (sources.size() > 1) {
            this.log.warn("Found more than one property source of type " + sourceClass);
        }
        return (S)((PropertySource)sources.get(0));
    }

    protected <S extends PropertySource<?>> List<S> findPropertySources(Class<S> sourceClass) {
        LinkedList<S> managedSources = new LinkedList<S>();
        LinkedList sources = this.toLinkedList((Iterable)this.environment.getPropertySources());
        while (!sources.isEmpty()) {
            PropertySource source = (PropertySource)sources.pop();
            if (source instanceof CompositePropertySource) {
                CompositePropertySource comp = (CompositePropertySource)source;
                sources.addAll(comp.getPropertySources());
                continue;
            }
            if (!sourceClass.isInstance(source)) continue;
            managedSources.add(sourceClass.cast(source));
        }
        return managedSources;
    }

    private <E> LinkedList<E> toLinkedList(Iterable<E> it) {
        LinkedList<E> list = new LinkedList<E>();
        for (E e : it) {
            list.add(e);
        }
        return list;
    }
}

