/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.spring.cloud.kubernetes;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.spring.cloud.kubernetes.PodUtils;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;

public class KubernetesHealthIndicator
extends AbstractHealthIndicator {
    private KubernetesClient client;
    private PodUtils utils;

    public KubernetesHealthIndicator(KubernetesClient client, PodUtils utils) {
        this.client = client;
        this.utils = utils;
    }

    protected void doHealthCheck(Health.Builder builder) throws Exception {
        try {
            Pod current = this.utils.currentPod().get();
            if (current != null) {
                builder.up().withDetail("inside", (Object)true).withDetail("podName", (Object)current.getMetadata().getName()).withDetail("podIp", (Object)current.getStatus().getPodIP()).withDetail("serviceAccount", (Object)current.getSpec().getServiceAccountName()).withDetail("nodeName", (Object)current.getSpec().getNodeName()).withDetail("hostIp", (Object)current.getStatus().getHostIP());
            } else {
                builder.up().withDetail("inside", (Object)false);
            }
        }
        catch (Exception e) {
            builder.down(e);
        }
    }
}

