/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.spring.cloud.kubernetes.profile;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.spring.cloud.kubernetes.PodUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;

public class KubernetesProfileApplicationListener
implements ApplicationListener<ApplicationEnvironmentPreparedEvent>,
Ordered {
    private static final Logger LOGGER = LoggerFactory.getLogger(KubernetesProfileApplicationListener.class);
    private static final String KUBERNETES_PROFILE = "kubernetes";
    private static final int OFFSET = 1;
    private static final int ORDER = -2147483647;
    private final PodUtils utils;

    public KubernetesProfileApplicationListener(PodUtils utils) {
        this.utils = utils;
    }

    public void onApplicationEvent(ApplicationEnvironmentPreparedEvent event) {
        ConfigurableEnvironment environment = event.getEnvironment();
        this.addKubernetesProfile(environment);
    }

    void addKubernetesProfile(ConfigurableEnvironment environment) {
        Pod current = this.utils.currentPod().get();
        if (current != null && !this.hasKubernetesProfile((Environment)environment)) {
            environment.addActiveProfile(KUBERNETES_PROFILE);
        }
        if (this.utils.isInsideKubernetes().booleanValue()) {
            if (this.hasKubernetesProfile((Environment)environment)) {
                LOGGER.debug("'kubernetes' already in list of active profiles");
            } else {
                LOGGER.debug("Adding 'kubernetes' to list of active profiles");
                environment.addActiveProfile(KUBERNETES_PROFILE);
            }
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.warn("Not running inside kubernetes. Skipping 'kuberntes' profile activation.");
        }
    }

    private boolean hasKubernetesProfile(Environment environment) {
        for (String activeProfile : environment.getActiveProfiles()) {
            if (!KUBERNETES_PROFILE.equalsIgnoreCase(activeProfile)) continue;
            return true;
        }
        return false;
    }

    public int getOrder() {
        return -2147483647;
    }
}

