/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.spring.cloud.kubernetes;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.EditableConfig;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.spring.cloud.kubernetes.KubernetesClientProperties;
import io.fabric8.spring.cloud.kubernetes.KubernetesHealthIndicator;
import io.fabric8.spring.cloud.kubernetes.StandardPodUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"spring.cloud.kubernetes.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={KubernetesClientProperties.class})
public class KubernetesAutoConfiguration {
    private static final Log LOG = LogFactory.getLog(KubernetesClientProperties.class);

    @Bean
    @ConditionalOnMissingBean(value={Config.class})
    public Config kubernetesClientConfig(KubernetesClientProperties kubernetesClientProperties) {
        Config base = new Config();
        EditableConfig properties = ((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)new ConfigBuilder(base).withMasterUrl(KubernetesAutoConfiguration.or(kubernetesClientProperties.getMasterUrl(), base.getMasterUrl()))).withApiVersion(KubernetesAutoConfiguration.or(kubernetesClientProperties.getApiVersion(), base.getApiVersion()))).withNamespace(KubernetesAutoConfiguration.or(kubernetesClientProperties.getNamespace(), base.getNamespace()))).withUsername(KubernetesAutoConfiguration.or(kubernetesClientProperties.getUsername(), base.getUsername()))).withPassword(KubernetesAutoConfiguration.or(kubernetesClientProperties.getPassword(), base.getPassword()))).withCaCertFile(KubernetesAutoConfiguration.or(kubernetesClientProperties.getCaCertFile(), base.getCaCertFile()))).withCaCertData(KubernetesAutoConfiguration.or(kubernetesClientProperties.getCaCertData(), base.getCaCertData()))).withClientKeyFile(KubernetesAutoConfiguration.or(kubernetesClientProperties.getClientKeyFile(), base.getClientKeyFile()))).withClientKeyData(KubernetesAutoConfiguration.or(kubernetesClientProperties.getClientKeyData(), base.getClientKeyData()))).withClientCertFile(KubernetesAutoConfiguration.or(kubernetesClientProperties.getClientCertFile(), base.getClientCertFile()))).withClientCertData(KubernetesAutoConfiguration.or(kubernetesClientProperties.getClientCertData(), base.getClientCertData()))).withClientKeyAlgo(KubernetesAutoConfiguration.or(kubernetesClientProperties.getClientKeyAlgo(), base.getClientKeyAlgo()))).withClientKeyPassphrase(KubernetesAutoConfiguration.or(kubernetesClientProperties.getClientKeyPassphrase(), base.getClientKeyPassphrase()))).withConnectionTimeout(KubernetesAutoConfiguration.or(kubernetesClientProperties.getConnectionTimeout(), base.getConnectionTimeout()).intValue())).withRequestTimeout(KubernetesAutoConfiguration.or(kubernetesClientProperties.getRequestTimeout(), base.getRequestTimeout()).intValue())).withRollingTimeout(KubernetesAutoConfiguration.or(kubernetesClientProperties.getRollingTimeout(), base.getRollingTimeout()).longValue())).withTrustCerts(KubernetesAutoConfiguration.or(kubernetesClientProperties.isTrustCerts(), base.isTrustCerts()).booleanValue())).build();
        if (properties.getNamespace() == null || properties.getNamespace().isEmpty()) {
            LOG.warn((Object)"No namespace has been detected. Please specify KUBERNETES_NAMESPACE env var, or use a later kubernetes version (1.3 or later)");
        }
        return properties;
    }

    @Bean
    @ConditionalOnMissingBean
    public KubernetesClient kubernetesClient(Config config) {
        return new DefaultKubernetesClient(config);
    }

    @Bean
    @ConditionalOnMissingBean
    StandardPodUtils kubernetesPodUtils(KubernetesClient client) {
        return new StandardPodUtils(client);
    }

    @Bean
    @ConditionalOnMissingBean
    public KubernetesHealthIndicator kubernetesHealthIndicator(KubernetesClient client, StandardPodUtils podUtils) {
        return new KubernetesHealthIndicator(client, podUtils);
    }

    private static <D> D or(D dis, D dat) {
        if (dis != null) {
            return dis;
        }
        return dat;
    }
}

