/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.spring.cloud.kubernetes.config;

import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.spring.cloud.kubernetes.config.ConfigMapConfigProperties;
import io.fabric8.spring.cloud.kubernetes.config.ConfigMapPropertySource;
import org.springframework.cloud.bootstrap.config.PropertySourceLocator;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;

@Order(value=0)
public class ConfigMapPropertySourceLocator
implements PropertySourceLocator {
    private static final String SPRING_APPLICATION_NAME = "spring.application.name";
    private static final String FALLBACK_APPLICATION_NAME = "application";
    private final KubernetesClient client;
    private final ConfigMapConfigProperties properties;

    public ConfigMapPropertySourceLocator(KubernetesClient client, ConfigMapConfigProperties properties) {
        this.client = client;
        this.properties = properties;
    }

    public PropertySource<?> locate(Environment environment) {
        if (environment instanceof ConfigurableEnvironment) {
            ConfigurableEnvironment env = (ConfigurableEnvironment)environment;
            String appName = env.getProperty(SPRING_APPLICATION_NAME, FALLBACK_APPLICATION_NAME);
            String name = this.properties.getName() == null || this.properties.getName().isEmpty() ? appName : this.properties.getName();
            String namespace = this.properties.getNamespace();
            return new ConfigMapPropertySource(this.client, name, namespace);
        }
        return null;
    }
}

