/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.spring.cloud.kubernetes;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.EditableConfig;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.spring.cloud.kubernetes.KubernetesClientProperties;
import io.fabric8.spring.cloud.kubernetes.KubernetesHealthIndicator;
import io.fabric8.spring.cloud.kubernetes.StandardPodUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"spring.cloud.kubernetes.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={KubernetesClientProperties.class})
public class KubernetesAutoConfiguration {
    @Autowired
    private KubernetesClientProperties properties;

    @Bean
    @ConditionalOnMissingBean(value={Config.class})
    public Config kubernetesClientConfig() {
        Config base = new Config();
        EditableConfig properites = ((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)new ConfigBuilder(base).withMasterUrl(KubernetesAutoConfiguration.or(this.properties.getMasterUrl(), base.getMasterUrl()))).withMasterUrl(KubernetesAutoConfiguration.or(this.properties.getApiVersion(), base.getApiVersion()))).withMasterUrl(KubernetesAutoConfiguration.or(this.properties.getApiVersion(), base.getMasterUrl()))).withUsername(KubernetesAutoConfiguration.or(this.properties.getUsername(), base.getUsername()))).withPassword(KubernetesAutoConfiguration.or(this.properties.getPassword(), base.getPassword()))).withCaCertFile(KubernetesAutoConfiguration.or(this.properties.getCaCertFile(), base.getCaCertFile()))).withCaCertData(KubernetesAutoConfiguration.or(this.properties.getCaCertData(), base.getCaCertData()))).withClientKeyFile(KubernetesAutoConfiguration.or(this.properties.getClientKeyFile(), base.getClientKeyFile()))).withClientKeyData(KubernetesAutoConfiguration.or(this.properties.getClientKeyData(), base.getClientKeyData()))).withClientCertFile(KubernetesAutoConfiguration.or(this.properties.getClientCertFile(), base.getClientCertFile()))).withClientCertData(KubernetesAutoConfiguration.or(this.properties.getClientCertData(), base.getClientCertData()))).withClientKeyAlgo(KubernetesAutoConfiguration.or(this.properties.getClientKeyAlgo(), base.getClientKeyAlgo()))).withClientKeyPassphrase(KubernetesAutoConfiguration.or(this.properties.getClientKeyPassphrase(), base.getClientKeyPassphrase()))).withConnectionTimeout(KubernetesAutoConfiguration.or(this.properties.getConnectionTimeout(), base.getConnectionTimeout()).intValue())).withRequestTimeout(KubernetesAutoConfiguration.or(this.properties.getRequestTimeout(), base.getRequestTimeout()).intValue())).withRollingTimeout(KubernetesAutoConfiguration.or(this.properties.getRollingTimeout(), base.getRollingTimeout()).longValue())).withTrustCerts(KubernetesAutoConfiguration.or(this.properties.isTrustCerts(), base.isTrustCerts()).booleanValue())).build();
        if (!base.equals(properites)) {
            System.out.println("Objects different");
        }
        return properites;
    }

    @Bean
    @ConditionalOnMissingBean
    public KubernetesClient kubernetesClient(Config config) {
        return new DefaultKubernetesClient(config);
    }

    @Bean
    @ConditionalOnMissingBean
    StandardPodUtils kubernetesPodUtils(KubernetesClient client) {
        return new StandardPodUtils(client);
    }

    @Bean
    @ConditionalOnMissingBean
    public KubernetesHealthIndicator kubernetesHealthIndicator(KubernetesClient client, StandardPodUtils podUtils) {
        return new KubernetesHealthIndicator(client, podUtils);
    }

    private static <D> D or(D dis, D dat) {
        if (dis != null) {
            return dis;
        }
        return dat;
    }
}

