/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.spring.cloud.kubernetes.config;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ClientResource;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.config.YamlPropertiesFactoryBean;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;

public class ConfigMapPropertySource
extends MapPropertySource {
    private static final String APPLICATION_YML = "application.yml";
    private static final String APPLICATION_YAML = "application.yaml";
    private static final String APPLICATION_PROPERTIES = "application.properties";
    private static final String PREFIX = "configmap";
    private static final String SEPARATOR = ".";
    private static final Function<String, Properties> YAML_TO_PROPETIES = s -> {
        YamlPropertiesFactoryBean yamlFactory = new YamlPropertiesFactoryBean();
        yamlFactory.setResources(new Resource[]{new ByteArrayResource(s.getBytes())});
        return yamlFactory.getObject();
    };
    private static final Function<String, Properties> KEY_VALUE_TO_PROPERTIES = s -> {
        Properties properties = new Properties();
        try {
            properties.load(new ByteArrayInputStream(s.getBytes()));
            return properties;
        }
        catch (IOException e) {
            throw new IllegalArgumentException();
        }
    };
    private static final Function<Properties, Map<String, String>> PROPERTIES_TO_MAP = p -> p.entrySet().stream().collect(Collectors.toMap(e -> String.valueOf(e.getKey()), e -> String.valueOf(e.getValue())));

    public ConfigMapPropertySource(KubernetesClient client, String name) {
        this(client, name, null);
    }

    public ConfigMapPropertySource(KubernetesClient client, String name, String namespace) {
        super(ConfigMapPropertySource.getName(client, name, namespace), ConfigMapPropertySource.asObjectMap(ConfigMapPropertySource.getData(client, name, namespace)));
    }

    private static String getName(KubernetesClient client, String name, String namespace) {
        StringBuilder sb = new StringBuilder();
        sb.append(PREFIX).append(SEPARATOR).append(name).append(SEPARATOR).append(namespace == null || namespace.isEmpty() ? client.getNamespace() : namespace);
        return sb.toString();
    }

    private static Map<String, String> getData(KubernetesClient client, String name, String namespace) {
        ConfigMap map;
        HashMap<String, String> result = new HashMap<String, String>();
        ConfigMap configMap = map = namespace == null || namespace.isEmpty() ? (ConfigMap)((ClientResource)client.configMaps().withName(name)).get() : (ConfigMap)((ClientResource)((ClientNonNamespaceOperation)client.configMaps().inNamespace(namespace)).withName(name)).get();
        if (map != null) {
            for (Map.Entry entry : map.getData().entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (key.equals(APPLICATION_YAML) || key.equals(APPLICATION_YML)) {
                    result.putAll(YAML_TO_PROPETIES.andThen(PROPERTIES_TO_MAP).apply(value));
                    continue;
                }
                if (key.equals(APPLICATION_PROPERTIES)) {
                    result.putAll(KEY_VALUE_TO_PROPERTIES.andThen(PROPERTIES_TO_MAP).apply(value));
                    continue;
                }
                result.put(key, value);
            }
        }
        return result;
    }

    private static Map<String, Object> asObjectMap(Map<String, String> source) {
        return source.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

