/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.spring.cloud.kubernetes.config;

import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.spring.cloud.kubernetes.KubernetesAutoConfiguration;
import io.fabric8.spring.cloud.kubernetes.config.ConfigMapConfigProperties;
import io.fabric8.spring.cloud.kubernetes.config.ConfigMapPropertySourceLocator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@ConditionalOnProperty(value={"spring.cloud.kubernetes.enabled"}, matchIfMissing=true)
public class ConfigMapBootstrapConfiguration {

    @Configuration
    @EnableConfigurationProperties(value={ConfigMapConfigProperties.class})
    @Import(value={KubernetesAutoConfiguration.class})
    @ConditionalOnProperty(name={"spring.cloud.kubernetes.config.enabled"}, matchIfMissing=true)
    protected static class KubernetesPropertySourceConfiguration {
        @Autowired
        private KubernetesClient client;

        protected KubernetesPropertySourceConfiguration() {
        }

        @Bean
        public ConfigMapPropertySourceLocator configMapPropertySourceLocator(ConfigMapConfigProperties properties) {
            return new ConfigMapPropertySourceLocator(this.client, properties);
        }
    }
}

