/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.commons.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;

public class InetUtils {
    public static int getIpAddressAsInt(String host) {
        return new HostInfo(host).getIpAddressAsInt();
    }

    public static final class HostInfo {
        public boolean override;
        private String ipAddress;
        private String hostname;

        HostInfo(String hostname) {
            this.hostname = hostname;
        }

        HostInfo() {
        }

        public int getIpAddressAsInt() {
            InetAddress inetAddress = null;
            String host = this.ipAddress;
            if (host == null) {
                host = this.hostname;
            }
            try {
                inetAddress = InetAddress.getByName(host);
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException(e);
            }
            return ByteBuffer.wrap(inetAddress.getAddress()).getInt();
        }

        public boolean isOverride() {
            return this.override;
        }

        public String getIpAddress() {
            return this.ipAddress;
        }

        public String getHostname() {
            return this.hostname;
        }

        public void setOverride(boolean override) {
            this.override = override;
        }

        public void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        public void setHostname(String hostname) {
            this.hostname = hostname;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof HostInfo)) {
                return false;
            }
            HostInfo other = (HostInfo)o;
            if (this.isOverride() != other.isOverride()) {
                return false;
            }
            String this$ipAddress = this.getIpAddress();
            String other$ipAddress = other.getIpAddress();
            if (this$ipAddress == null ? other$ipAddress != null : !this$ipAddress.equals(other$ipAddress)) {
                return false;
            }
            String this$hostname = this.getHostname();
            String other$hostname = other.getHostname();
            return !(this$hostname == null ? other$hostname != null : !this$hostname.equals(other$hostname));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isOverride() ? 79 : 97);
            String $ipAddress = this.getIpAddress();
            result = result * 59 + ($ipAddress == null ? 43 : $ipAddress.hashCode());
            String $hostname = this.getHostname();
            result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
            return result;
        }

        public String toString() {
            return "InetUtils.HostInfo(override=" + this.isOverride() + ", ipAddress=" + this.getIpAddress() + ", hostname=" + this.getHostname() + ")";
        }
    }
}

