/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.spring.cloud.kubernetes.archaius;

import com.google.common.base.Strings;
import com.netflix.config.WatchedConfigurationSource;
import com.netflix.config.WatchedUpdateListener;
import com.netflix.config.WatchedUpdateResult;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class ArchaiusConfigMapSourceConfiguration
implements InitializingBean,
DisposableBean,
WatchedConfigurationSource,
Closeable {
    private final KubernetesClient client;
    private final String name;
    private final String namespace;
    private final List<WatchedUpdateListener> listeners = new ArrayList<WatchedUpdateListener>();
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();
    private AtomicReference<Map<String, Object>> currentData = new AtomicReference();
    private Watch watch;
    private volatile Watcher<ConfigMap> watcher = new Watcher<ConfigMap>(){

        public void eventReceived(Watcher.Action action, ConfigMap configMap) {
            ArchaiusConfigMapSourceConfiguration.this.offer(WatchedUpdateResult.createFull((Map)ArchaiusConfigMapSourceConfiguration.asObjectMap(configMap.getData())));
        }

        public void onClose(KubernetesClientException e) {
        }
    };

    public ArchaiusConfigMapSourceConfiguration(KubernetesClient client, String name, String namespace) {
        this.client = client;
        this.name = name;
        this.namespace = namespace;
    }

    public void start() {
        ConfigMap map;
        ConfigMap configMap = map = Strings.isNullOrEmpty((String)this.namespace) ? (ConfigMap)((Resource)this.client.configMaps().withName(this.name)).get() : (ConfigMap)((Resource)((NonNamespaceOperation)this.client.configMaps().inNamespace(this.namespace)).withName(this.name)).get();
        if (map != null) {
            this.currentData.set(ArchaiusConfigMapSourceConfiguration.asObjectMap(map.getData()));
        }
        this.watch = Strings.isNullOrEmpty((String)this.namespace) ? (Watch)((Resource)this.client.configMaps().withName(this.name)).watch(this.watcher) : (Watch)((Resource)((NonNamespaceOperation)this.client.configMaps().inNamespace(this.namespace)).withName(this.namespace)).watch(this.watcher);
        this.started.set(true);
    }

    @Override
    public void close() throws IOException {
        this.started.set(false);
        if (this.watch != null) {
            this.watch.close();
        }
        this.executorService.shutdown();
    }

    public synchronized void addUpdateListener(WatchedUpdateListener watchedUpdateListener) {
        this.listeners.add(watchedUpdateListener);
    }

    public synchronized void removeUpdateListener(WatchedUpdateListener watchedUpdateListener) {
        this.listeners.remove(watchedUpdateListener);
    }

    public Map<String, Object> getCurrentData() throws Exception {
        return this.currentData.get();
    }

    private void offer(WatchedUpdateResult event) {
        this.submit(() -> {
            this.listeners.stream().forEach(l -> l.updateConfiguration(event));
            this.currentData.set(event.getComplete());
        });
    }

    private synchronized void submit(Runnable command) {
        if (this.started.get()) {
            this.executorService.submit(command);
        }
    }

    private static Map<String, Object> asObjectMap(Map<String, String> source) {
        return source.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public void destroy() throws Exception {
        this.close();
    }

    public void afterPropertiesSet() throws Exception {
        this.start();
    }
}

