/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.spring.cloud.kubernetes.archaius;

import com.netflix.config.DynamicWatchedConfiguration;
import io.fabric8.spring.cloud.kubernetes.archaius.ArchaiusConfigMapSource;
import io.fabric8.spring.cloud.kubernetes.archaius.ArchaiusConfigMapSourceConfiguration;
import java.util.Map;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.StringUtils;

class ArchaiusConfigMapSourceRegistar
implements ImportBeanDefinitionRegistrar {
    private static final String KUBERNETES_CLIENT_REF = "kubernetesClient";
    private static final String VALUE_ATTR = "value";
    private static final String NAME_ATTR = "name";
    private static final String NAMESPACE_ATTR = "namespace";
    private static final String CONFIG_MAP_SOURCE_SUFFIX = ".ConfigMapSourceConfiguration";
    private static final String DYNAMIC_WATCH_CONFIG_SUFFIX = ".DynamicWatchedConfiguration";

    ArchaiusConfigMapSourceRegistar() {
    }

    public void registerBeanDefinitions(AnnotationMetadata metadata, BeanDefinitionRegistry registry) {
        Map source = metadata.getAnnotationAttributes(ArchaiusConfigMapSource.class.getName(), true);
        String name = this.getSourceName(source);
        String namespace = this.getSourceNamespace(source);
        if (name != null) {
            this.registerSourceConfiguration(registry, name, namespace);
        }
    }

    private String getSourceName(Map<String, Object> source) {
        if (source == null) {
            return null;
        }
        String value = (String)source.get(VALUE_ATTR);
        if (!StringUtils.hasText((String)value)) {
            value = (String)source.get(NAME_ATTR);
        }
        if (StringUtils.hasText((String)value)) {
            return value;
        }
        throw new IllegalStateException("Either 'name' or 'value' must be provided in @ConfigMapSource");
    }

    private String getSourceNamespace(Map<String, Object> source) {
        if (source == null) {
            return null;
        }
        String namespace = (String)source.get(NAMESPACE_ATTR);
        if (StringUtils.hasText((String)namespace)) {
            return namespace;
        }
        return null;
    }

    private void registerSourceConfiguration(BeanDefinitionRegistry registry, Object name, Object namespace) {
        BeanDefinitionBuilder configMapSourceConfigBuilder = BeanDefinitionBuilder.genericBeanDefinition(ArchaiusConfigMapSourceConfiguration.class);
        BeanDefinitionBuilder dynamicWatchedConfigBuilder = BeanDefinitionBuilder.genericBeanDefinition(DynamicWatchedConfiguration.class);
        configMapSourceConfigBuilder.addConstructorArgReference(KUBERNETES_CLIENT_REF);
        configMapSourceConfigBuilder.addConstructorArgValue(name);
        configMapSourceConfigBuilder.addConstructorArgValue(namespace);
        String configMapSourceConfigName = name + CONFIG_MAP_SOURCE_SUFFIX;
        registry.registerBeanDefinition(configMapSourceConfigName, (BeanDefinition)configMapSourceConfigBuilder.getBeanDefinition());
        String dynamicWatchedConfigName = name + DYNAMIC_WATCH_CONFIG_SUFFIX;
        dynamicWatchedConfigBuilder.addConstructorArgReference(configMapSourceConfigName);
        registry.registerBeanDefinition(dynamicWatchedConfigName, (BeanDefinition)dynamicWatchedConfigBuilder.getBeanDefinition());
    }
}

