/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.spring.cloud.discovery;

import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.spring.cloud.discovery.KubernetesDiscoveryClient;
import io.fabric8.spring.cloud.discovery.KubernetesDiscoveryLifecycle;
import io.fabric8.spring.cloud.discovery.KubernetesDiscoveryProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"spring.cloud.kubernetes.enabled"}, matchIfMissing=true)
public class KubernetesDiscoveryAutoConfiguration {
    @Bean
    public KubernetesDiscoveryProperties kubernetesDiscoveryProperties() {
        return new KubernetesDiscoveryProperties();
    }

    @Bean
    @ConditionalOnMissingBean
    public KubernetesDiscoveryClient kubernetesDiscoveryClient(KubernetesClient client, KubernetesDiscoveryProperties properties) {
        return new KubernetesDiscoveryClient(client, properties.getServiceName());
    }

    @Bean
    public KubernetesDiscoveryLifecycle kubernetesDiscoveryLifecycle(KubernetesClient client, KubernetesDiscoveryProperties properties) {
        return new KubernetesDiscoveryLifecycle(client, properties);
    }
}

