/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.servicecatalog.examples;

import io.fabric8.servicecatalog.api.model.ClusterServiceClassList;
import io.fabric8.servicecatalog.client.ServiceCatalogClient;
import io.fabric8.servicecatalog.client.internal.ClusterServiceBrokerResource;
import io.fabric8.servicecatalog.examples.ClientFactory;

public class ListServiceClassesByBroker {
    public static void main(String[] args) {
        ServiceCatalogClient client = ClientFactory.newClient(args);
        String broker = ClientFactory.getOptions(args, "--broker", null);
        if (broker == null || broker.isEmpty()) {
            System.out.println("Missing --broker option!");
            System.exit(1);
        }
        System.out.println("Listing Cluster Service Classes" + broker + ":");
        ClusterServiceClassList list = ((ClusterServiceBrokerResource)client.clusterServiceBrokers().withName(broker)).listClasses();
        list.getItems().stream().forEach(b -> System.out.println(b.getSpec().getExternalName() + "\t\t\t\t" + b.getMetadata().getName()));
        System.out.println("Done");
    }
}

