/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.process.spring.boot.registry;

import com.google.common.base.Objects;
import io.fabric8.process.spring.boot.registry.ProcessRegistry;
import io.fabric8.process.spring.boot.registry.ZooKeeperProcessRegistries;
import org.apache.curator.CuratorConnectionLossException;
import org.apache.curator.framework.CuratorFramework;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperProcessRegistry
implements ProcessRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(ZooKeeperProcessRegistry.class);
    private final String hosts;
    private final CuratorFramework zk;

    public ZooKeeperProcessRegistry(String hosts) {
        this.hosts = hosts;
        this.zk = ZooKeeperProcessRegistries.newCurator(hosts);
    }

    public static ZooKeeperProcessRegistry autodetectZooKeeperProcessRegistry() {
        String hosts = (String)Objects.firstNonNull((Object)System.getProperty("fabric8.process.registry.zk.hosts"), (Object)"localhost:2181");
        return new ZooKeeperProcessRegistry(hosts);
    }

    public String hosts() {
        return this.hosts;
    }

    @Override
    public String readProperty(String key) {
        String path = this.convertPropertiesKeyToPath(key);
        try {
            return new String((byte[])this.zk.getData().forPath(path));
        }
        catch (KeeperException.NoNodeException e) {
            LOG.debug("NoNodeException thrown for path {}. Returning null.", (Object)path);
            return null;
        }
        catch (CuratorConnectionLossException e) {
            LOG.warn("CuratorConnectionLossException thrown for path {}. Returning null.", (Object)path);
            return null;
        }
        catch (KeeperException.ConnectionLossException e) {
            LOG.warn("ConnectionLossException thrown for path {}. Returning null.", (Object)path);
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected String convertPropertiesKeyToPath(String key) {
        return "/" + key.replace('.', '/');
    }
}

