/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.process.spring.boot.registry;

import com.google.common.collect.Maps;
import io.fabric8.process.spring.boot.registry.ProcessRegistry;
import java.util.Collections;
import java.util.Map;

public class InMemoryProcessRegistry
implements ProcessRegistry {
    private final Map<String, Object> registry;

    public InMemoryProcessRegistry(Map<String, Object> registryContents) {
        this.registry = Maps.newHashMap(registryContents);
    }

    public InMemoryProcessRegistry() {
        this(Collections.EMPTY_MAP);
    }

    @Override
    public String readProperty(String key) {
        String property = System.getProperty(key);
        if (property != null) {
            return property;
        }
        Object value = this.registry.get(key);
        if (value == null) {
            return null;
        }
        return value.toString();
    }
}

